% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrected_standard_estimator.R
\name{solve_shrinking}
\alias{solve_shrinking}
\title{Solve Linear Shrinking}
\usage{
solve_shrinking(par, corr_mat, target)
}
\arguments{
\item{par}{The initial parameter  used in the maximisation process.}

\item{corr_mat}{The autocorrelation matrix of the considered time series.}

\item{target}{A shrinkage target matrix used in the shrinking process. This should only be used if you wish to use a specific matrix as the target.}
}
\value{
A numeric value that is either equal to \eqn{-}\code{par} or 1.
}
\description{
This is an objective function used to select \eqn{\lambda \in [0, 1]} in linear shrinking, see \link{shrinking}.
}
\examples{
estCorr <- c(1, 0.5, 0)
corr_mat <- cyclic_matrix(estCorr)
solve_shrinking(0.5, corr_mat, diag(length(estCorr)))
}
\references{
Devlin, S. J., Gnanadesikan R. & Kettenring, J. R. (1975). Robust Estimation and Outlier Detection with Correlation Coefficients. Biometrika, 62(3), 531-545. 10.1093/biomet/62.3.531

Rousseeuw, P. J. & Molenberghs, G. (1993). Transformation of Non Positive Semidefinite Correlation Matrices. Communications in Statistics - Theory and Methods, 22(4), 965–984. 10.1080/03610928308831068
}
