% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutStat.R
\name{mutStat}
\alias{mutStat}
\title{Plot mutation statistics for nucleiotide}
\usage{
mutStat(
  nucmerr = nucmerr,
  outdir = NULL,
  figure_Type = "TopMuSample",
  type_top = 10,
  country = FALSE,
  mutpos = NULL
)
}
\arguments{
\item{nucmerr}{Mutation information containing group list(derived from "nucmer" object using "nucmerRMD" function).}

\item{outdir}{The output directory.}

\item{figure_Type}{Figure type for: "TopMuSample", "AverageMu", "TopMuPos", "MutDens", "CountryMutCount", "TopCountryMut".}

\item{type_top}{To plot the figure involving "top n"("TopMuSample", "TopMuPos", "TopCountryMut"), the "type_top" should specify the number of objects to display.}

\item{country}{To plot the figure using country as groups("CountryMutCount" and "TopCountryMut"), the "country" should be TRUE.}

\item{mutpos}{If the figure type is "TopCountryMut", "mutpos" can specify
A range of genomic position(eg. 28831:28931) for plot}
}
\value{
Plot the selected figure type as output.
}
\description{
Visualization for the top mutated samples, average mutational counts,
top mutated position in the genome, mutational density across the genome
and distribution of mutations across countries.
}
\examples{
data("nucmerr")
outdir <- tempdir()
mutStat(nucmerr = nucmerr,
        outdir = outdir,
        figure_Type = "TopCountryMut",
        type_top = 10,
        country = FALSE,
        mutpos = NULL)
}
