% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocking_factor.R
\name{blocking_factor}
\alias{blocking_factor}
\title{Calculate blocking factor}
\usage{
blocking_factor(node_list, edge_list)
}
\arguments{
\item{node_list}{Dataframe with an 'id' column for each node and a
'term' column specifying which term the course is to be taken in.}

\item{edge_list}{Dataframe with two columns 'from' and 'to' specifying
directed edges starting at 'from' nodes directed towards 'to' nodes. Entries
must use node ids from \code{node_list}.}
}
\value{
A list that contains the following: \item{bynode}{A dataframe
containing the blocking factor of each node} \item{total}{The total blocking
factor of the curriculum graph}
}
\description{
A helper function for calculating the blocking factor for each node and the
total blocking factor of a curriculum graph.
}
\details{
Blocking quantifies when a failing a course would result in being blocked from registering for future courses. More formally the blocking factor of a node \eqn{v_i} is defined as
\deqn{b_c(v_i) = \sum_{v_j \in V} I(v_i,v_j)} where \eqn{I} is the indicator
function: \deqn{=\begin{cases}1, & \text{if } v_i \to v_j \\ 0, &
\text{if }v_i \not\to v_j\end{cases}}
The blocking factor for an entire curriculum graph \eqn{G_c} is defined as
\deqn{b(G_c)=\sum_{v_i \in V} b_c(v_i)}
}
\examples{
edge_list <- data.frame(from = c(1, 3), to = c(3, 4))
node_list <-
data.frame(
id = 1:4,
label = c("MATH 100", "DATA 101", "MATH 101", "MATH 221"),
term = c(1, 1, 2, 2)
)
bf_list <- blocking_factor(node_list,edge_list)
print(bf_list)
# Output:
# $bynode
# id bf
# 2  1  2
# 3  2  0
# 4  3  1
# 5  4  0
# $total
# [1] 3
}
\references{
Heileman, Gregory L, Chaouki T Abdallah, Ahmad Slim, and Michael
Hickman. 2018. “Curricular Analytics: A Framework for Quantifying the Impact
of Curricular Reforms and Pedagogical Innovations.” arXiv Preprint
arXiv:1811.09676.
}
\author{
Daniel Krasnov
}
