% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynAccuracy.R
\name{dynAccuracy}
\alias{dynAccuracy}
\title{Calculate accuracy}
\usage{
dynAccuracy(predTest, depTest, dyn.cutoff = FALSE, cutoff = 0.5,
  predVal = NULL, depVal = NULL)
}
\arguments{
\item{predTest}{Vector with predictions (real-valued or discrete)}

\item{depTest}{Vector with real class labels}

\item{dyn.cutoff}{Logical indicator to enable dynamic threshold determination using
validation sample predictions. In this case, the function determines, using validation
data, the indidicence (occurrence percentage of the customer behavior or characterstic
of interest) and chooses a cutoff value so that the number of predicted positives is
equal to the number of true positives. If \code{TRUE}, then the value for the cutoff
parameter is ignored.}

\item{cutoff}{Threshold for converting real-valued predictions into class predictions.
Default 0.5.}

\item{predVal}{Vector with predictions (real-valued or discrete). Only used if
\code{dyn.cutoff} is \code{TRUE}.}

\item{depVal}{Optional vector with true class labels for validation data. Only used
if \code{dyn.cutoff} is \code{TRUE}.}
}
\value{
Accuracy value
\item{accuracy}{accuracy value}
\item{cutoff}{the threshold value used to convert real-valued predictions to class
predictions}
}
\description{
Calculates accuracy (percentage correctly classified instances) for real-valued
classifier predictions, with the optional ability to dynamically determine an
incidence-based cutoff value using validation sample predictions
}
\examples{
## Load response modeling data set
data("response")
## Apply dynAccuracy function to obtain the accuracy that is achieved on the test sample.
## Use validation sample predictions to dynamically determine a cutoff value.
acc<-dynAccuracy(response$test[,2],response$test[,1],dyn.cutoff=TRUE,predVal=
response$val[,2],depVal=response$val[,1])
print(acc)

}
\seealso{
\code{\link{dynConfMatrix}},\code{\link{confMatrixMetrics}}
}
\author{
Koen W. De Bock, \email{kdebock@audencia.com}
}
