% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fitLCmulti.R
\name{plot.fitLCmulti}
\alias{plot.fitLCmulti}
\title{Function to plot the parameters of the multi-population mortality models}
\usage{
\method{plot}{fitLCmulti}(x, ...)
}
\arguments{
\item{x}{\code{x} developed using function \code{fitLCmulti()} which are objects of the \code{fitLCmulti} class.}

\item{...}{additional arguments to show in the plot appearance.}
}
\value{
plot the different parameters for the multi-population mortality models \code{ax}, \code{bx}, \code{kt} and \code{Ii}. This function is valid for both approaches Additive and Multiplicative multi-population mortality models.
}
\description{
R function to plot the parameters for the additive (Debon et al., 2011), multiplicative (Russolillo et al., 2011), common-factor (CFM) (Carter and Lee, 1992), Joint-k (Carter and Lee, 1992), and augmented-common factor (ACFM) (Li and Lee, 2005) multi-Population mortality model.
It should be mentioned that in case that this function is developed for fitting several populations.
However, in case you only consider one population, the function will fit the one-population Lee-Carter model (Lee and Carter, 1992).
}
\examples{
#The example takes more than 5 seconds because it includes
#several fitting and forecasting process and hence all
#the process is included in donttest
\donttest{
#First, we present the data that we are going to use
SpainRegions
ages <- c(0, 1, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90)

library(gnm)
library(forecast)
#1. ADDITIVE MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the additive multi-population mortality model
additive_Spainmales <- fitLCmulti(model = "additive",
                              qxt = SpainRegions$qx_male,
                              periods = c(1991:2020),
                              ages = c(ages),
                              nPop = 18,
                              lxt = SpainRegions$lx_male)

additive_Spainmales

#If the user does not provide the model inside the function fitLCmult()
#the multi-population mortality model applied will be additive one.

#Once, we have fit the data, it is possible to see the ax, bx, kt, and Ii
#provided parameters for the fitting.
plot(additive_Spainmales)

#2. MULTIPLICATIVE MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the multiplicative multi-population mortality model
multiplicative_Spainmales <- fitLCmulti(model = "multiplicative",
                              qxt = SpainRegions$qx_male,
                              periods = c(1991:2020),
                              ages = c(ages),
                              nPop = 18,
                              lxt = SpainRegions$lx_male)

multiplicative_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, kt, and It
#provided parameters for the fitting.
plot(multiplicative_Spainmales)

#3. COMMON-FACTOR MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the common-factor multi-population mortality model
cfm_Spainmales <- fitLCmulti(model = "CFM",
                             qxt = SpainRegions$qx_male,
                             periods = c(1991:2020),
                             ages = c(ages),
                             nPop = 18,
                             lxt = SpainRegions$lx_male)

cfm_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, kt, and It
#provided parameters for the fitting.
plot(cfm_Spainmales)

#4. JOINT-K MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the augmented-common-factor multi-population mortality model
jointk_Spainmales <- fitLCmulti(model = "joint-K",
                                qxt = SpainRegions$qx_male,
                                periods = c(1991:2020),
                                ages = c(ages),
                                nPop = 18,
                                lxt = SpainRegions$lx_male)

jointk_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, kt, and It
#provided parameters for the fitting.
plot(jointk_Spainmales)

#5. AUGMENTED-COMMON-FACTOR MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the augmented-common-factor multi-population mortality model
acfm_Spainmales <- fitLCmulti(model = "ACFM",
                              qxt = SpainRegions$qx_male,
                              periods = c(1991:2020),
                              ages = c(ages),
                              nPop = 18,
                              lxt = SpainRegions$lx_male)

acfm_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, kt, and It
#provided parameters for the fitting.
plot(acfm_Spainmales)

#6. LEE-CARTER FOR SINGLE-POPULATION
#As we mentioned in the details of the function, if we only provide the data
#from one-population the function fitLCmulti()
#will fit the Lee-Carter model for single populations.
LC_Spainmales <- fitLCmulti(qxt = SpainNat$qx_male,
                              periods = c(1991:2020),
                              ages = ages,
                              model = "additive",
                              nPop = 1)

LC_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, and kt
#parameters provided for the single version of the LC.
plot(LC_Spainmales)

}
}
\references{
Carter, L.R. and Lee, R.D. (1992).
Modeling and forecasting US sex differentials in mortality.
International Journal of Forecasting, 8(3), 393–411.

Debon, A., Montes, F., & Martinez-Ruiz, F. (2011).
Statistical methods to compare mortality for a group with non-divergent populations: an application to Spanish regions.
European Actuarial Journal, 1, 291-308.

Lee, R.D. & Carter, L.R. (1992).
Modeling and forecasting US mortality.
Journal of the American Statistical Association, 87(419), 659–671.

Li, N. and Lee, R.D. (2005).
Coherent mortality forecasts for a group of populations: An extension of the Lee-Carter method.
Demography, 42(3), 575–594.

Russolillo, M., Giordano, G., & Haberman, S. (2011).
Extending the Lee–Carter model: a three-way decomposition.
Scandinavian Actuarial Journal, 2011(2), 96-117.

Villegas, A. M., Haberman, S., Kaishev, V. K., & Millossovich, P. (2017).
A comparative study of two-population models for the assessment of basis risk in longevity hedges.
ASTIN Bulletin, 47(3), 631-679.
}
\seealso{
\code{\link{fitLCmulti}}, \code{\link{forecast.fitLCmulti}},
\code{\link{plot.forLCmulti}}, \code{\link{multipopulation_cv}}
}
