% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyt_violin.R
\name{cyt_violin}
\alias{cyt_violin}
\title{Violin Plots for Continuous Variables with Optional Grouping}
\usage{
cyt_violin(
  data,
  output_file = NULL,
  group_by = NULL,
  bin_size = 25,
  y_lim = NULL,
  scale = c("none", "log2", "log10", "zscore", "custom"),
  custom_fn = NULL,
  boxplot_overlay = FALSE
)
}
\arguments{
\item{data}{A matrix or data frame containing numeric and
categorical variables.}

\item{output_file}{Optional string specifying the name of the file
to be created.  When \code{NULL} (default), plots are drawn on
the current graphics device. Ensure that the file
extension matches the desired format (e.g., ".pdf" for PDF output
or ".png" for PNG output or .tiff for TIFF output).}

\item{group_by}{Optional character vector specifying one or more
columns to use for grouping.  If \code{NULL} (default) no grouping is
applied.}

\item{bin_size}{Integer.  Maximum number of violins per page when
grouping is not used.  Default is 25, mirroring \code{cyt_bp}.}

\item{y_lim}{Optional numeric vector giving y‑axis limits for the
plots.  Applies to all plots.}

\item{scale}{Character specifying a transformation for numeric
variables.  Accepts "none", "log2", "log10",
"zscore", or "custom".  When "custom", supply a
function via \code{custom_fn}.}

\item{custom_fn}{A user supplied function to transform numeric
columns when \code{scale = "custom"}.}

\item{boxplot_overlay}{Logical.  When \code{TRUE}, a narrow boxplot is
drawn inside each violin to summarize the median and quartiles.
Default is \code{FALSE}.}
}
\value{
Invisibly returns a list of \code{ggplot} objects.  When
\code{output_file} is provided, plots are written to the PDF file.
}
\description{
\code{cyt_violin} produces violin plots for each numeric variable in
\code{data}, optionally grouped by one or more categorical variables.
When grouping is not specified, the function behaves similarly to
\code{cyt_bp} but uses violins instead of boxplots and supports
pagination via the \code{bin_size} argument.  When grouping is
provided, a separate violin is drawn for each level (or
interaction of levels) of the grouping variables.  Users may
optionally overlay boxplots within each violin to visualize the
median and interquartile range.
}
\examples{
# Violin plots without grouping
cyt_violin(ExampleData1[, -c(1:3)], output_file = NULL, scale = "zscore")
# Violin plots grouped by Group with boxplot overlay
cyt_violin(ExampleData1[, -c(3,5:28)], group_by = "Group",
                        boxplot_overlay = TRUE, scale = "log2")
}
\author{
Shubh Saraswat
}
