\name{LakeSuperiour.rdata}
\alias{LakeSuperior}
\docType{data}
\title{210Pb measurements and derived age models from Lake Superior}
\description{
Contains lead measurments and the derived age models and sediment accumulation rates from eight cores in Lake Superior (O'Beirne et al. 2017)
}
\usage{data(LakeSuperior)}
\format{A list containing eight data tables, each with the information about one core.
}

\examples{
data(LakeSuperior)
plot(LakeSuperior$BH03_3$Depth..m.,LakeSuperior$BH03_3$X210Pb.xs..Bq.kg.,
  xlab='Core depth [m]',ylab='Excess lead [Bq/kg]')
}
\source{
O'Beirne, Molly D; Werne, Josef P; Hecky, Robert E; Johnson, Thomas C; Katsev, Sergei; Reavie, Euan D (2017): 210Pb based age model of sediment core BH03-3. PANGAEA, https://doi.org/10.1594/PANGAEA.874717 \href{https://creativecommons.org/licenses/by/3.0/}{CC BY 3.0}

O'Beirne, Molly D; Werne, Josef P; Hecky, Robert E; Johnson, Thomas C; Katsev, Sergei; Reavie, Euan D (2017): 210Pb based age model of sediment core BH09-2. PANGAEA, https://doi.org/10.1594/PANGAEA.874718 \href{https://creativecommons.org/licenses/by/3.0/}{CC BY 3.0}

O'Beirne, Molly D; Werne, Josef P; Hecky, Robert E; Johnson, Thomas C; Katsev, Sergei; Reavie, Euan D (2017): 210Pb based age model of sediment core BH09-3. PANGAEA, https://doi.org/10.1594/PANGAEA.874719 \href{https://creativecommons.org/licenses/by/3.0/}{CC BY 3.0}

O'Beirne, Molly D; Werne, Josef P; Hecky, Robert E; Johnson, Thomas C; Katsev, Sergei; Reavie, Euan D (2017): 210Pb based age model of sediment core BH09-4. PANGAEA, https://doi.org/10.1594/PANGAEA.874720 \href{https://creativecommons.org/licenses/by/3.0/}{CC BY 3.0}

O'Beirne, Molly D; Werne, Josef P; Hecky, Robert E; Johnson, Thomas C; Katsev, Sergei; Reavie, Euan D (2017): 210Pb based age model of sediment core CM_MC. PANGAEA, https://doi.org/10.1594/PANGAEA.874721 \href{https://creativecommons.org/licenses/by/3.0/}{CC BY 3.0}

O'Beirne, Molly D; Werne, Josef P; Hecky, Robert E; Johnson, Thomas C; Katsev, Sergei; Reavie, Euan D (2017): 210Pb based age model of sediment core EM_MC. PANGAEA, https://doi.org/10.1594/PANGAEA.874722 \href{https://creativecommons.org/licenses/by/3.0/}{CC BY 3.0}

O'Beirne, Molly D; Werne, Josef P; Hecky, Robert E; Johnson, Thomas C; Katsev, Sergei; Reavie, Euan D (2017): 210Pb based age model of sediment core IR_MC. PANGAEA, https://doi.org/10.1594/PANGAEA.874723 \href{https://creativecommons.org/licenses/by/3.0/}{CC BY 3.0}

O'Beirne, Molly D; Werne, Josef P; Hecky, Robert E; Johnson, Thomas C; Katsev, Sergei; Reavie, Euan D (2017): 210Pb based age model of sediment core LG_MC. PANGAEA, https://doi.org/10.1594/PANGAEA.874724 \href{https://creativecommons.org/licenses/by/3.0/}{CC BY 3.0}
}

\references{
O'Beirne, MD et al. (2017): Anthropogenic climate change has altered primary productivity in Lake Superior. Nature Communications, 8, 15713, https://doi.org/10.1038/ncomms15713
}

\keyword{dataset}
\keyword{Lake Superior}
\keyword{Lead}
\keyword{Stratigraphy}