% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.DALSM.R
\name{print.DALSM}
\alias{print.DALSM}
\title{Print summary information on a \code{DALSM.object}}
\usage{
\method{print}{DALSM}(x,...)
}
\arguments{
\item{x}{an object of class \code{\link{DALSM.object}}.}

\item{...}{additional generic printing arguments.}
}
\value{
No returned value (just printed summary).
}
\description{
Print summary information on a \code{DALSM.object}.
}
\details{
Provides summary measures on the estimation of the regression parameters and additive terms
in the location and dispersion submodels corresponding to a \code{\link{DALSM.object}} generated by \code{\link{DALSM}}.
}
\examples{
require(DALSM)
data(DALSM_IncomeData)
resp = DALSM_IncomeData[,1:2]
fit = DALSM(y=resp,
            formula1 = ~twoincomes+s(age)+s(eduyrs),
            formula2 = ~twoincomes+s(age)+s(eduyrs),
            data = DALSM_IncomeData)
print(fit)

}
\references{
Lambert, P. (2021). Fast Bayesian inference using Laplace approximations
in nonparametric double additive location-scale models with right- and
interval-censored data.
\emph{Computational Statistics and Data Analysis}, 161: 107250.
<doi:10.1016/j.csda.2021.107250>
}
\seealso{
\code{\link{plot.DALSM}}, \code{\link{DALSM.object}}, \code{\link{DALSM}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
