% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportCodebook.R
\name{exportCodebook}
\alias{exportCodebook}
\title{Export a DDI Codebook to an XML file.}
\usage{
exportCodebook(codeBook, to = "", OS = "", indent = 2, ...)
}
\arguments{
\item{codeBook}{A standard element of class \code{"DDI"}.}

\item{to}{either a character string naming a file or a connection open for
writing ("" indicates output to the console)}

\item{OS}{The target operating system, for the eol - end of line character(s)}

\item{indent}{Indent width, in number of spaces}

\item{...}{Other arguments, mainly for internal use}
}
\value{
An XML file containing a DDI version 2.6 metadata.
}
\description{
Create a DDI Codebook version 2.6, XML file structure.
}
\details{
#' The information object is a \code{codeBook} DDI element having at least two
main children:
\itemize{
\item \strong{\code{fileDscr}}, with the data provided as a sub-component named
\strong{\code{datafile}}
\item \strong{\code{dataDscr}}, having as many components as the number of variables in the
(meta)data.
}

For the moment, only DDI codebook version 2.6 is exported, and DDI Lifecycle
is planned for future releases.

A small number of required DDI specific elements and attributes have generic
default values, if not otherwise specified in the \code{codeBook} list object. For
the current version, these are: \code{monolang}, \code{xmlang}, \code{IDNo}, \code{titl},
\code{agency}, \code{URI} (for the \code{holdings} element), \code{distrbtr}, \code{abstract} and
\code{level} (for the \code{otherMat} element).

The \code{codeBook} object is exported as provided, and it is the user's
responsibility to test its validity against the XML schema. Most of these
arguments help create the mandatory element \code{stdyDscr}, which cannot be
harvested from the dataset. If this element is not already present, providing
any of these arguments via the three dots \code{...} gate, signal an automatic
creation and inclusion with the values provided.

Argument \strong{\code{xmlang}} expects a two letter ISO country coding, for instance
\code{"en"} to indicate English, or \code{"ro"} to indicate Romanian etc. The original
DDI Codebook attribute is called \strong{\code{xml:lang}}, which for obvious reasons
had to be renamed into this R function.

A logical argument \code{monolang} signal if the document is monolingual, in which
case the attribute \code{xmlang} is placed a single time for the entire document
in the \code{codeBook} element. For multilingual documents, \code{xmlang} should be
placed in the attributes of various other (child) elements, for instance
\code{abstract}, or the study title, name of the distributing institution,
variable labels etc.

The argument \strong{\code{OS}} can be either:\cr
\code{"windows"} (default), or \code{"Windows"}, \code{"Win"}, \code{"win"},\cr
\code{"MacOS"}, \code{"Darwin"}, \code{"Apple"}, \code{"Mac"}, \code{"mac"},\cr
\code{"Linux"}, \code{"linux"}.

The end of line separator changes only when the target OS is different from
the running OS.

The argument \strong{\code{indent}} controls how many spaces will be used in the XML
file, to indent the different sub-elements.
}
\examples{
\dontrun{
exportCodebook(codeBook, to = "codebook.xml")

# using a namespace
exportCodebook(codeBook, to = "codebook.xml", xmlns = "ddi")
}

}
\seealso{
\url{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation.html}
}
\author{
Adrian Dusa
}
