predict_DDPstar.varfun <-
function(object, object.regfun = NULL, newdata, parallel = c("no", "multicore", "snow"), ncpus = 1, cl = NULL) {
	doMCMC <- function(k, object, Xp, regfun) {
		ncomp <- ncol(object$fit$probs)
		if(ncomp == 1) {
			Beta <- matrix(object$fit$beta[k,,], nrow = 1)
		} else {
			Beta <- object$fit$beta[k,,]
		}
		aux1 <- sum(object$fit$probs[k,]*object$fit$sd[k,]^2)		
		aux <- colSums(object$fit$probs[k,]*t((Xp%*%t(Beta))^2))
		varfun <- aux + aux1 - regfun[,k]^2

		res <- list()
		res$varfun <- varfun
		res$foo <- 1
		res
	}

	if(is.null(object.regfun)) {
		# Obtain regression function
		res <- predict_DDPstar.regfun(object = object, newdata = newdata, select = NULL, parallel = parallel, ncpus = ncpus, cl = cl)
		Xp <- res$Xp
		regfun <- res$regfun
	} else {
		if(!inherits(object.regfun, "DDPstar.regfun")) {
			stop("Class of object 'object.regfun' is not correct")
		}
		if(is.null(object.regfun$select)) {
			Xp <- object.regfun$Xp
			regfun <- object.regfun$regfun
		} else {
			warning("Class of object 'object.regfun' is not correct")
			res <- predict_DDPstar.regfun(object = object, newdata = newdata, select = NULL, parallel = parallel, ncpus = ncpus, cl = cl)
			Xp <- res$Xp
			regfun <- res$regfun
		}
	}

	parallel <- match.arg(parallel)
	nsim <- nrow(object$fit$sd)

	if(nsim > 0) {
		do_mc <- do_snow <- FALSE
	    if (parallel != "no" && ncpus > 1L) {
	        if (parallel == "multicore") {
	            do_mc <- .Platform$OS.type != "windows"
	        } else if (parallel == "snow") {
	            do_snow <- TRUE
	        }
	        if (!do_mc && !do_snow) {
	            ncpus <- 1L
	        }       
	        loadNamespace("parallel") # get this out of the way before recording seed
	    }

	    resMCMC <- if (ncpus > 1L && (do_mc || do_snow)) {
                if (do_mc) {
                    parallel::mclapply(seq_len(nsim), doMCMC, object = object, Xp = Xp, regfun = regfun, mc.cores = ncpus)
                } else if (do_snow) {                
                    if (is.null(cl)) {
                        cl <- parallel::makePSOCKcluster(rep("localhost", ncpus))
                        if(RNGkind()[1L] == "L'Ecuyer-CMRG") {
                            parallel::clusterSetRNGStream(cl)
                        }
                        res <- parallel::parLapply(cl, seq_len(nsim), doMCMC, object = object, Xp = Xp, regfun = regfun)
                        parallel::stopCluster(cl)
                        res
                    } else {
                        if(!inherits(cl, "cluster")) {
                            stop("Class of object 'cl' is not correct")
                        } else {
                            parallel::parLapply(cl, seq_len(nsim), doMCMC, object = object, Xp = Xp, regfun = regfun)
                        }                        
                    }
                }
            } else {
                lapply(seq_len(nsim), doMCMC, object = object, Xp = Xp, regfun = regfun)
            }

        resMCMC <- simplify2array(resMCMC)
        varfun <- simplify2array(resMCMC["varfun",])

	} else {
		stop("nsave should be larger than zero.")
	}

	res <- list()
	res$Xp <- Xp
	res$varfun <- varfun
	class(res) <- "DDPstar.varfun"
	res
}
