predict_bbase.bs <-
function(object, newx) {
	knots <- attr(object,"knots")
	bdeg <- attr(object,"bdeg")
	eps <- attr(object,"eps")
	intercept <- attr(object,"intercept")
	U.X <- attr(object,"U.X")
	U.Z <- attr(object,"U.Z")
	
	B <- splines::spline.des(knots, newx, ord = bdeg + 1 , outer.ok = TRUE)$design
	
	# SVD of the penalty matrix
	X <- B%*%U.X
	Z <- B%*%U.Z

	if(!intercept) {
		# Remove the intercept
		X.reduced <- X[,-1, drop = FALSE]
		B <- cbind(X.reduced, Z)
	} else {
		B <- cbind(X, Z)
	}
	# Center the matrix
	cm <- attr(object, "cm")
	B <- sweep(B, 2, cm)
	attr(B,"X") <- X
	attr(B,"Z") <- Z
	B
}
