\name{rae}
\alias{rae}
\title{
Defining random effects in DDPstar formulae
}
\description{
Auxiliary function used to define random effects terms in a \code{DDPstar} model formula.
}
\usage{
rae(x, atau = 1, btau = 0.005)
}
\arguments{
  \item{x}{the x-variable (factor) that defines the random effects term.}
\item{atau}{A numeric value. Hyperparameter; shape parameter of the gamma prior distribution for the precision (inverse variance) of the random effect term. The default is 1.}
\item{btau}{A numeric value. Hyperparameter; rate parameter of the gamma prior distribution for the precision (inverse variance) of the random effect term. The default is 0.005.}
}
\details{
The functions is designed to represent random effects in DDPstar formulae. 
}
\value{The function is interpreted in the formula of a \code{DDPstar} model and creates the right framework for fitting the random effect. List containing the following elements:
  \item{vars}{name of the covariate involved.}
  \item{atau}{shape parameter of the gamma prior distribution}
  \item{btau}{rate parameter of the gamma prior distribution}
}
\references{
Rodriguez-Alvarez, M. X, Inacio, V. and Klein N. (2025). Density regression via Dirichlet process mixtures of normal structured additive regression models. Accepted for publication in Statistics and Computing (DOI: 10.1007/s11222-025-10567-0).
}
\seealso{
\code{\link{f}}, \code{\link{DDPstar}}
}
\examples{
# For an example including random effects, we refer to Rodriguez-Alvarez, Inacio et al. (2025) 
# and associated codes (found in https://bitbucket.org/mxrodriguez/ddpstar)
}
