% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAnalysis.R
\name{compare_alternatives}
\alias{compare_alternatives}
\title{compare_alternatives}
\usage{
compare_alternatives(
  model,
  alternative,
  alternatives = NULL,
  root = NULL,
  compare = TRUE,
  deep = TRUE,
  print = TRUE,
  as_character = FALSE,
  round = NULL,
  id = NULL,
  evaluate = FALSE,
  ...
)
}
\arguments{
\item{model}{A \link{DexiModel} object. Required.}

\item{alternative}{Either a \code{data.frame} representing a single alternative or
an integer index to \code{model$alternatives}.}

\item{alternatives}{Either a \code{data.frame} representing one or more alternatives,
or an integer numeric vector representing indices to \code{model$alternatives}.
By default, \code{alternatives} are set to \code{model$alternatives},
possibly excluding \code{alternative} when indexed.}

\item{root}{Optional \link{DexiAttribute} object.
When specified, only attributes that affect \code{root} are included in the analysis.
Otherwise, all \code{model$attributes} are included.}

\item{compare}{\code{logical(1)}.
Whether or not preference relations \verb{"<", ">", "<=", ">="} are included in results.}

\item{deep}{\code{logical(1)}.
Whether of not "deep" comparison (see \code{\link[=compare_two_alternatives]{compare_two_alternatives()}}) is carried out.}

\item{print}{\code{logical(1)}. When \code{TRUE}, pretty print (left justify) the results.}

\item{as_character}{\code{logical(1)}. Whether to represent alternative values
numerically (\code{FALSE}) or using text (\code{TRUE}).}

\item{round}{An integer number, argument to \code{\link[=value_text]{value_text()}}.}

\item{id}{\code{character(1)}.
Determines the contents of the first or first two columns of the resulting \code{data.frame}:
\describe{
\item{\code{"id"}}{Attribute ID.}
\item{\code{"structure"}}{Attribute \verb{$structure() + $name}.}
\item{anything else}{Equivalent to both \code{"id"} and \code{"structure"}.}
}}

\item{evaluate}{\code{logical(1)}. Whether or not to evaluate \code{alternative} and \code{alternatives} beforehand.}

\item{...}{Optional parameters for \code{\link[=evaluate]{evaluate()}}.}
}
\value{
Returns or prints a \code{data.frame} consisting of columns:
\code{id} (if requested), \code{structure} (if requested),
values of \code{alternative} and comparison results for each alternative from \code{alternatives}.
}
\description{
Compare Alternatives Analysis: Compare \code{alternative} with each of \code{alternatives}.
Display only values that differ and, optionally when \code{compare = TRUE}, include
preference-relational operators.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

# Extend Car$alternatives
car3 <- set_alternative(Car, Car$alternatives[2,], name = "Car3", LUGGAGE = 2)
Car$alternatives[3,] <- car3
car4 <- set_alternative(Car, Car$alternatives[2,], name = "Car4", LUGGAGE = 1)

# Compare Car1 with the other two, varying some arguments
compare_alternatives(Car, 1, evaluate=TRUE, compare=FALSE)
compare_alternatives(Car, 1, evaluate=TRUE, compare=TRUE)
compare_alternatives(Car, 1, evaluate=TRUE, compare=TRUE, deep=FALSE)

# Compare Car2 with Car1
compare_alternatives(Car, 2, 1)

# Compare car3 with Car1 and Car2
compare_alternatives(Car, car3, 1:2)

# Compare car4 with Car$alternatives
compare_alternatives(Car, car4)

# Compare Car$alternatives[1,] with car3
compare_alternatives(Car, 1, car3)
compare_alternatives(Car, Car$alternatives[1,], car3)
}
\seealso{
\code{\link[=compare_two_alternatives]{compare_two_alternatives()}}, \code{\link[=evaluate]{evaluate()}}
}
