% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAlternatives.R
\name{alt_values}
\alias{alt_values}
\title{alt_values}
\usage{
alt_values(alt, attributes, as_character = TRUE, round = NULL)
}
\arguments{
\item{alt}{\code{data.frame} representing a single alternative.}

\item{attributes}{A vector of \link{DexiAttribute} objects.}

\item{as_character}{\verb{logical(1).}. Determines whether to represent alternative values numerically
("internal representation") (\code{FALSE}) or as character strings (using \code{\link[=value_text]{value_text()}}) (\code{TRUE}).}

\item{round}{A single integer. An optional argument to \code{\link[=value_text]{value_text()}}.}
}
\value{
\code{character(length(attributes))}. String representation of \code{alt}'s values.
}
\description{
Make a list of \code{alternative}'s values corresponding to \code{attributes}.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

unlist(alt_values(Car$alternatives[1,], Car$attributes, as_character = TRUE))
# c("NULL", "exc", "low", "medium", "low", "exc", "high", "more", "4", "big", "high")
}
\seealso{
\code{\link[=value_text]{value_text()}}
}
