% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiCharts.R
\name{plotalt_parallel}
\alias{plotalt_parallel}
\title{plotalt_parallel}
\usage{
plotalt_parallel(
  model,
  alternatives = NULL,
  attids = NULL,
  aggregate = c("minmax", "min", "max", "mean", "none"),
  name = "name",
  shift = 0.01,
  linewidth = 2,
  pointsize = 3,
  split = c("no", "h", "v")
)
}
\arguments{
\item{model}{A \link{DexiModel} object. Required.}

\item{alternatives}{A \code{data.frame} of alternatives (normally an output of \code{\link[=evaluate]{evaluate()}}) or
indices to \code{model$alternatives}. The default value \code{NULL} selects the whole \code{model$alternatives}.}

\item{attids}{\code{character()}. A character vector of \link{DexiAttribute} IDs to be included in the result.
Default: all \code{model} attributes.}

\item{aggregate}{One of \code{"minmax"}, \code{"min"}, \code{"max"}, \code{"mean"} or "\code{none}". Determines how
to aggregate \code{alternatives} values that are represented by sets or distributions.}

\item{name}{\code{character(1)}, The name of the column in \code{alternatives} that contains
alternatives' names. Default: \code{"name"}.}

\item{shift}{\code{numeric(1)}. Used to "shift" numeric results by a small amount to avoid overlapping
lines in charts. Default: \code{0.01}.
You may want to experiment with charts to determine the right value,}

\item{linewidth}{\code{numeric(1)}. Widths of lines drawn.}

\item{pointsize}{\code{numeric(1)}. Size of points drawn.}

\item{split}{One of:
\describe{
\item{\code{"no"}}{Draw all alternatives on the same chart.}
\item{\code{"v"}}{Split the chart vertically and draw alternatives separately.}
\item{\code{"h"}}{Split the chart horizontally and draw alternatives separately.}
}}
}
\value{
A 'ggplot2' chart, enhanced with additional graph layers.
}
\description{
Makes and plots DEXi alternatives on parallel axes, corresponding to attributes.
Generally, axes are uniformly scaled to the \verb{[0,1]} interval.
}
\details{
Data presented in the chart is prepared by \code{\link[=scale_alternatives]{scale_alternatives()}}.
\code{plotalt_parallel()} invokes \code{\link[=ggplot_parallel]{ggplot_parallel()}} to make a basic chart and then
enhances it with graphic layers that are suitable for presenting DEXi alternatives.
}
\examples{
if (requireNamespace("GGally", quietly = TRUE)) {

# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

# Plot all Car$alternatives with points and lines
plotalt_parallel(Car)

# Show alternatives on two separate chart segments, shown one above the other.
plotalt_parallel(Car, split = "v")

alts3 <- structure(
list(
  name = c("MyCar", "MyCar2", "MyCar1b"),
    CAR.1 = list(4L, 4L, c(1L, 4L)),
    PRICE = list(3L, 3L, c(1L, 3L)),
    BUY.PRICE = list(3L, 3L, 3L),
    MAINT.PRICE = list(2, 1, structure(c(0.1, 0.6, 0.3), class = "distribution")),
    TECH.CHAR. = list(3L, 3:4, 3L),
    COMFORT = list(3L, 2, 3L),
    X.PERS = list(3, 3, 3L),
    X.DOORS = list(3, 3, 3L),
    LUGGAGE = list(2L, 2L, 2),
    SAFETY = list(2, c(2, 3), 2)
    ),
    row.names = c(NA, -3L),
    class = "data.frame"
 )

# Plot `alts2` with points and lines.
# Notice the "minmax" aggregation of sets and distributions.
plotalt_parallel(Car, alts3)
plotalt_parallel(Car, alts3, split = "v")

# Now with "mean" aggregation
plotalt_parallel(Car, alts3, split = "v", aggregate = "mean")
}
}
\seealso{
\code{\link[=scale_alternatives]{scale_alternatives()}}, \code{\link[=ggplot_parallel]{ggplot_parallel()}}
}
