% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{Spdeplisa}
\alias{Spdeplisa}
\title{Calculate Local Moran's I and Sign Combination Variables}
\usage{
Spdeplisa(data, variable_name, listw)
}
\arguments{
\item{data}{A dataframe containing the spatial data.}

\item{variable_name}{A string representing the name of the variable to be analyzed.}

\item{listw}{A listw object containing spatial weights for the dataset.}
}
\value{
A data frame containing the original data with additional columns:
\item{lisa_I}{Local Moran's I values for the specified variable.}
\item{lisa_p}{P-values corresponding to the Local Moran's I values.}
\item{z_i}{Standardized values of the input variable.}
\item{sign_combination2}{Categories based on the sign of z_i and lisa_I (e.g., "positive-negative").}
\item{sign_combination3}{Categories based on the sign of z_i and lisa_I (e.g., "High-High").}
}
\description{
This function calculates Local Moran's I for a specified variable in a dataset
and creates sign combination variables based on the standardized variable
and the local Moran's I values.
}
\examples{
# Load necessary libraries
if (requireNamespace("spData", quietly = TRUE)) {
  library(spData)
  library(sf)
  library(dplyr)

  # Use US states data as a substitute for a shapefile
  us_states <- spData::us_states

  # Simplify for demonstration: Select a subset of columns
  us_states_data <- us_states \%>\%
    select(GEOID, NAME) \%>\%
    mutate(mean_wealth = rnorm(nrow(us_states), 50, 10))  # Add mock data

  # Define a temporary shapefile path
  shapefile_path <- tempfile(fileext = ".shp")
  sf::st_write(us_states, shapefile_path, quiet = TRUE)

  # Create spatial weights using the listw function from the package
  us_states_listw <- DHSr::listw(
    shapefile_path = shapefile_path,
    data = us_states_data \%>\% sf::st_drop_geometry(),  # Drop geometry for compatibility
    loc_shape = "GEOID",
    loc_data = "GEOID",
    weight_function = function(d) exp(-d / 0.2)
  )

  # Apply the Spdeplisa function
  lisa_result <- DHSr::Spdeplisa(
    data = us_states_data,
    variable_name = "mean_wealth",
    listw = us_states_listw
  )

  # View the result
  head(lisa_result)
}
}
