% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIscBIO-generic-DEGanalysis2clust.R
\name{DEGanalysis2clust}
\alias{DEGanalysis2clust}
\alias{DEGanalysis2clust,DISCBIO-method}
\title{Determining differentially expressed genes (DEGs) between two
  particular clusters.}
\usage{
DEGanalysis2clust(
  object,
  K,
  Clustering = "K-means",
  fdr = 0.05,
  name = "Name",
  First = "CL1",
  Second = "CL2",
  export = FALSE,
  quiet = FALSE,
  plot = TRUE,
  filename_deg = "DEGsTable",
  filename_sigdeg = "sigDEG",
  ...
)

\S4method{DEGanalysis2clust}{DISCBIO}(
  object,
  K,
  Clustering = "K-means",
  fdr = 0.05,
  name = "Name",
  First = "CL1",
  Second = "CL2",
  export = FALSE,
  quiet = FALSE,
  plot = TRUE,
  filename_deg = "DEGsTable",
  filename_sigdeg = "sigDEG",
  ...
)
}
\arguments{
\item{object}{\code{DISCBIO} class object.}

\item{K}{A numeric value of the number of clusters.}

\item{Clustering}{Clustering has to be one of the following:
["K-means","MB"]. Default is "K-means"}

\item{fdr}{A numeric value of the false discovery rate. Default is 0.05.}

\item{name}{A string vector showing the name to be used to save the resulted
tables.}

\item{First}{A string vector showing the first target cluster.  Default is
"CL1"}

\item{Second}{A string vector showing the second target cluster.  Default is
"CL2"}

\item{export}{A logical vector that allows writing the final gene list in
excel file. Default is TRUE.}

\item{quiet}{if `TRUE`, suppresses intermediate text output}

\item{plot}{if `TRUE`, plots are generated}

\item{filename_deg}{Name of the exported DEG table}

\item{filename_sigdeg}{Name of the exported sigDEG table}

\item{...}{additional parameters to be passed to samr()}
}
\value{
A list containing two tables.
}
\description{
This function defines DEGs between particular clusters generated
  by either K-means or model based clustering.
}
