% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCEM.R
\name{MCEM}
\alias{MCEM}
\title{MCEM Algorithm for Missing Response Variables}
\description{
  Implements the Monte Carlo EM algorithm for handling missing response data in linear regression models.
}
\usage{
MCEM(data, d = 5, tol = 0.01, nb = 50)
}
\arguments{
  \item{data}{
    A data frame with the response variable in the first column and predictors in the remaining columns.
  }
  \item{d}{
    Initial convergence threshold. Defaults to 5.
  }
  \item{tol}{
    Termination tolerance. Defaults to 0.01.
  }
  \item{nb}{
    Maximum number of iterations. Defaults to 50.
  }
}
\value{
  A list containing the following components:
  \item{Yhat}{Imputed response vector with missing values filled in.}
  \item{betahat}{Final regression coefficients.}
  \item{iterations}{Number of iterations performed.}
}
\details{
  This function implements the Monte Carlo Expectation-Maximization (MCEM) algorithm to handle missing response variables in linear regression models.
  The algorithm iteratively imputes missing responses and updates regression coefficients until convergence.
}
\examples{
  # Create dataset with 20% missing responses
  set.seed(123)
  data <- data.frame(
    Y = c(rnorm(80), rep(NA, 20)),
    X1 = rnorm(100),
    X2 = runif(100)
  )
  result <- MCEM(data, d = 5, tol = 0.001, nb = 100)
  print(result$Yhat)  # Imputed response vector
  print(result$betahat)  # Final regression coefficients
  print(result$iterations)  # Number of iterations performed
}