% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_modeling.R
\name{SVM_predict}
\alias{SVM_predict}
\title{Predictive Modeling using Support Vector Machine}
\usage{
SVM_predict(
  x_train,
  y_train,
  x_test,
  lims,
  kernel = "rbf",
  optimize = FALSE,
  C = 2,
  kpar = list(sigma = 0.1),
  eps = 0.01,
  seed = NULL,
  verbose = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{x_train}{Training features for designing the SVM regressor.}

\item{y_train}{Training response for designing the SVM regressor.}

\item{x_test}{Test features for which response values are to be predicted.
If \code{x_test} is not given, the function will return the trained model.}

\item{lims}{Vector providing the range of the response values for modeling.
If missing, these values are estimated from the training response.}

\item{kernel}{Kernel function for SVM implementation. The available options
are \code{linear}, \code{poly}, \code{rbf}, and \code{tanh}. Defaults to \code{rbf}.}

\item{optimize}{Flag for model tuning. If \code{TRUE}, performs a grid search for
parameters. If \code{FALSE}, uses the parameters provided. Defaults to \code{FALSE}.}

\item{C}{Cost of constraints violation. This is the constant "C" of the
regularization term in the Lagrange formulation. Defaults to \code{2}. Valid only
when \code{optimize = FALSE}.}

\item{kpar}{List of kernel parameters. This is a named list that contains
the parameters to be used with the specified kernel. The valid parameters
for the existing kernels are -
\itemize{
\item \code{sigma} for the radial basis (rbf) kernel. Note that this is the
\strong{inverse} kernel width.
\item \code{degree}, \code{scale}, \code{offset} for the polynomial kernel.
\item \code{scale}, \code{offset} for the hyperbolic tangent kernel.
}

Valid only when \code{optimize = FALSE}. Defaults to \code{list(sigma = 0.1)}.}

\item{eps}{The insensitive-loss function used for epsilon-SVR. Defaults to
\code{0.01}.}

\item{seed}{Seed for random number generator (for reproducible outcomes).
Defaults to \code{NULL}.}

\item{verbose}{Flag for printing the tuning progress when \code{optimize = TRUE}.
Defaults to \code{FALSE}.}

\item{parallel}{Flag for allowing parallel processing when performing grid
search \emph{i.e.}, \code{optimimze = TRUE}. Defaults to \code{FALSE}.}
}
\value{
If \code{x_test} is missing, the trained SVM regressor.

If \code{x_test} is provided, the predicted values using the model.
}
\description{
This function trains a Support Vector Machine regressor using the training
data provided and predict response for the test features. This implementation
depends on the \code{kernlab} package.
}
\note{
The response values are filtered to be bound by range in \code{lims}.
}
\examples{
set.seed(86420)
x <- matrix(rnorm(3000, 0.2, 1.2), ncol = 3);    colnames(x) <- paste0("x", 1:3)
y <- 0.3*x[, 1] + 0.1*x[, 2] - x[, 3] + rnorm(1000, 0, 0.05)

## Get the model only...
model <- SVM_predict(x_train = x[1:800, ], y_train = y[1:800], kernel = "rbf")

## Get predictive performance...
y_pred <- SVM_predict(x_train = x[1:800, ], y_train = y[1:800], x_test = x[801:1000, ])
y_test <- y[801:1000]
print(performance(y_test, y_pred, measures = "RSQ"))

}
\keyword{support-vector-machine}
\keyword{support-vector-regression}
