% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_match.R
\name{dist_match}
\alias{dist_match}
\title{Distribution Matching for Source and Reference Datasets}
\usage{
dist_match(
  src,
  ref,
  src_cdf,
  ref_cdf,
  lims,
  density = FALSE,
  samples = 1e+06,
  seed = NULL
)
}
\arguments{
\item{src}{Vector containing the source data to be matched.}

\item{ref}{Vector containing the reference data to estimate the reference
distribution for matching.}

\item{src_cdf}{Vector containing source distribution values. If missing,
these values are estimated from the source data using \code{estimate_cdf()}.}

\item{ref_cdf}{Vector containing reference distribution values. If missing,
these values are estimated from the reference data using \code{estimate_cdf()}.}

\item{lims}{Vector providing the range of the knot values for mapping. If
missing, these values are estimated from the reference data.}

\item{density}{Flag for using kernel density estimates for matching instead
of histogram counts. Defaults to \code{False}.}

\item{samples}{Sample size for estimating distributions if \code{src_cdf} and/or
\code{ref_cdf} are missing. Defaults to \code{1e6}.}

\item{seed}{Seed for random number generator (for reproducible outcomes).
Defaults to \code{NULL}.}
}
\value{
A vector containing the matched values corresponding to \code{src}.
}
\description{
This function matches a source distribution to a given reference distribution
such that the data in the source space can effectively be transferred to the
reference space \emph{i.e.} domain transfer \emph{via} distribution matching.
}
\examples{
set.seed(7531)
x1 <- rnorm(100, 0.2, 0.6)
x2 <- runif(200)
matched <- dist_match(src = x1, ref = x2, lims = c(0, 1))

## Plot histograms...
opar <- par(mfrow = c(1, 3))
hist(x1);    hist(x2);    hist(matched)
par(opar)              # Reset par

}
\keyword{distribution-matching}
\keyword{domain-transfer}
