% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPTM_r6_class.R
\name{DPTM}
\alias{DPTM}
\title{Dynamic Panel Multiple Threshold Model with Fixed Effects (DPTM)}
\format{
[R6::R6Class] object.
}
\description{
Use a MCMC-MLE based on two-step procedure to estimate the dynamic panel multiple threshold model with fixed effects.
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{coefficients}}{a named vector of coefficients}

\item{\code{NNLL}}{the negative log-likelihood function value}

\item{\code{Zvalues}}{a vector of t statistics}

\item{\code{Ses}}{a vector of standard errors}

\item{\code{covariance_matrix}}{a covariance matrix}

\item{\code{duit}}{a vector of residuals after difference}

\item{\code{dy0}}{a vector of dependent variable after difference}

\item{\code{Th}}{the number of thresholds}

\item{\code{thresholds}}{a named vector of thresholds}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DPTM-new}{\code{DPTM$new()}}
\item \href{#method-DPTM-capture_input}{\code{DPTM$capture_input()}}
\item \href{#method-DPTM-MLE}{\code{DPTM$MLE()}}
\item \href{#method-DPTM-TModel_fit}{\code{DPTM$TModel_fit()}}
\item \href{#method-DPTM-MCMC_process}{\code{DPTM$MCMC_process()}}
\item \href{#method-DPTM-print}{\code{DPTM$print()}}
\item \href{#method-DPTM-clone}{\code{DPTM$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DPTM-new"></a>}}
\if{latex}{\out{\hypertarget{method-DPTM-new}{}}}
\subsection{Method \code{new()}}{
initialize Initializing method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DPTM$new(
  data,
  index = NULL,
  Th = NULL,
  iterations = NULL,
  sro = NULL,
  w = NULL,
  var_u = NULL,
  iterlim = NULL,
  restart = FALSE,
  delty0 = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{data.frame used}

\item{\code{index}}{variable names of individuals and period; If a setting is not provided, defaults (the first variables in data will be as "id", while the second will be "year") will be used}

\item{\code{Th}}{number of thresholds; If a setting is not provided, defaults (Th = 0) will be used}

\item{\code{iterations}}{MCMC iterations (50\% used for burnining)}

\item{\code{sro}}{regime (subsample) proportion; If a setting is not provided, defaults (10\%) will be used}

\item{\code{w}}{variances ratio initial value; If a setting is not provided, defaults (automatic calculation) will be used}

\item{\code{var_u}}{variances (T>=2) initial value; If a setting is not provided, defaults (automatic calculation) will be used}

\item{\code{iterlim}}{the maximum number of iterations; If a setting is not provided, defaults (iterlim = 500) will be used}

\item{\code{restart}}{logicals. If MLE fails, set it as TRUE}

\item{\code{delty0}}{a vector of dependent variable after difference}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DPTM-capture_input"></a>}}
\if{latex}{\out{\hypertarget{method-DPTM-capture_input}{}}}
\subsection{Method \code{capture_input()}}{
Identify and capturing inputs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DPTM$capture_input(
  formula = NULL,
  formula_cv = NULL,
  timeFE,
  y1 = NULL,
  q = NULL,
  r0x = NULL,
  r1x = NULL,
  NoY = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{formula of the covariates with threshold effects;If a setting is not provided, defaults (no covariates with threshold effects) will be used}

\item{\code{formula_cv}}{formula of the covariates without threshold effects;If a setting is not provided, defaults (no covariates without threshold effects) will be used}

\item{\code{timeFE}}{logicals. If TRUE the time fixed effects will be allowed}

\item{\code{y1}}{lags of dependent variables; If a setting is not provided, defaults (the first-order lag) will be used}

\item{\code{q}}{threshold variable}

\item{\code{r0x}}{lower bound of threshold parameter space; If a setting is not provided, defaults (15\% quantile of threshold variable) will be used}

\item{\code{r1x}}{upper bound of threshold parameter space; If a setting is not provided, defaults (85\% quantile of threshold variable) will be used}

\item{\code{NoY}}{logicals. If TRUE the lags of dependent variables will be without threshold effects}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DPTM-MLE"></a>}}
\if{latex}{\out{\hypertarget{method-DPTM-MLE}{}}}
\subsection{Method \code{MLE()}}{
Maximum likelihood estimation method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DPTM$MLE(ny = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ny}}{the number of regimes}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DPTM-TModel_fit"></a>}}
\if{latex}{\out{\hypertarget{method-DPTM-TModel_fit}{}}}
\subsection{Method \code{TModel_fit()}}{
Compute coefficients given thresholds
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DPTM$TModel_fit(ga)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ga}}{thresholds}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DPTM-MCMC_process"></a>}}
\if{latex}{\out{\hypertarget{method-DPTM-MCMC_process}{}}}
\subsection{Method \code{MCMC_process()}}{
Use MCMC to compute thresholds
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DPTM$MCMC_process(
  proportion = 0.5,
  types = "DREAMzs",
  ADs = FALSE,
  nCR = 3,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{proportion}}{the proportion of burning in the whole iterations}

\item{\code{types}}{the type of MCMC, see BayesianTools::runMCMC}

\item{\code{ADs}}{the parameter of MCMC, see BayesianTools::runMCMC}

\item{\code{nCR}}{the parameter of MCMC, see BayesianTools::runMCMC}

\item{\code{...}}{the settings of MCMC, see BayesianTools::applySettingsDefault}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DPTM-print"></a>}}
\if{latex}{\out{\hypertarget{method-DPTM-print}{}}}
\subsection{Method \code{print()}}{
print and print estimated results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DPTM$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{DPTM object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DPTM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DPTM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DPTM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
