% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataAccess.R
\name{histogramDataAccess}
\alias{histogramDataAccess}
\title{Differentially Private Histogram Data Access Function}
\usage{
histogramDataAccess(x, breaks, mechanism)
}
\arguments{
\item{x}{Numeric vector from which the histogram will be formed..}

\item{breaks}{Identical to the argument with the same name from
\code{\link[graphics]{hist}}.}

\item{mechanism}{String indicating which mechanism to use for differential
privacy. If the 'Laplace' mechanism is chosen, l1 sensitivities are
returned. If the 'Gaussian' or 'analytic' mechanisms are chosen, l2
sensitivities are returned.}
}
\value{
List of the true histogram and the sensitivities calculated based on
bounded and unbounded differential privacy.
}
\description{
This function performs the data access step in the computation of a
differentially private histogram. The true values are computed using
\code{\link[graphics]{hist}}, while the sensitivities are calculated based on
bounded and unbounded differential privacy \insertCite{Kifer2011}{DPpack}
according to the theoretical values \insertCite{Liu2019b}{DPpack}.
}
\examples{
histogramDataAccess(c(1,4,3,2,3), 'Sturges', 'Laplace')

}
\references{
\insertRef{Liu2019b}{DPpack}

\insertRef{Kifer2011}{DPpack}
}
\keyword{internal}
