% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plausibility_results.R
\name{uniq_plausi_results}
\alias{uniq_plausi_results}
\title{uniq_plausi_results helper function}
\usage{
uniq_plausi_results(rv, uniq_vars, mdr, headless = FALSE)
}
\arguments{
\item{rv}{A list object. Internal list simulating Shiny's
'reactive values'.}

\item{uniq_vars}{A data.table object. The object is created
by \code{create_helper_vars} from the data represented in
the metadata repository.}

\item{mdr}{A data.table object containing the MDR.}

\item{headless}{A boolean (default: FALSE). Indicating, if the function is
run only in the console (headless = TRUE) or on a GUI frontend
(headless = FALSE).}
}
\value{
A list with one entry for each uniqueness plausibility check
containing the results. Each entry contains the following (nested) list
items:
\describe{
\item{description}{A character with the description of the plausibility
check.}
\item{source_data}{A nested list with the uniqueness plausibility check
results for the source data system with the values 'message' and 'error'.}
\item{target_data}{A nested list with the uniqueness plausibility check
results for the target data system with the values 'message' and 'error'.}
}
}
\description{
Internal function to generate the results of
the 'Uniqueness Plausibility' checks.
}
\examples{
\donttest{# runtime > 5 sec.
utils_path <- system.file(
  "demo_data/utilities/",
  package = "DQAstats"
)
mdr_filename <- "mdr_example_data.csv"
rv <- list()
rv$mdr <- read_mdr(
  utils_path = utils_path,
  mdr_filename <- mdr_filename
)

source_system_name <- "exampleCSV_source"
target_system_name <- "exampleCSV_target"

rv <- c(rv, create_helper_vars(
  mdr = rv$mdr,
  source_db = source_system_name,
  target_db = target_system_name
))
# save source/target vars
rv$source$system_name <- source_system_name
rv$target$system_name <- target_system_name
rv$source$system_type <- "csv"
rv$target$system_type <- "csv"

rv$log$logfile_dir <- tempdir()

# set headless (without GUI, progressbars, etc.)
rv$headless <- TRUE

# set configs
demo_files <- system.file("demo_data", package = "DQAstats")
Sys.setenv("EXAMPLECSV_SOURCE_PATH" = demo_files)
Sys.setenv("EXAMPLECSV_TARGET_PATH" = demo_files)

# get configs
rv$source$settings <- DIZutils::get_config_env(
  system_name = rv$source$system_name,
  logfile_dir = rv$log$logfile_dir,
  headless = rv$headless
)
rv$target$settings <- DIZutils::get_config_env(
  system_name = tolower(rv$target$system_name),
  logfile_dir = rv$log$logfile_dir,
  headless = rv$headless
)

# set start_time (e.g. when clicking the 'Load Data'-button in shiny
rv$start_time <- format(Sys.time(), usetz = TRUE, tz = "CET")

# define restricting date
rv$restricting_date$use_it <- FALSE

# load source data
tempdat <- data_loading(
  rv = rv,
  system = rv$source,
  keys_to_test = rv$keys_source
)
rv$data_source <- tempdat$outdata

# load target data
tempdat <- data_loading(
  rv = rv,
  system = rv$target,
  keys_to_test = rv$keys_target
)
rv$data_target <- tempdat$outdata

rv$data_plausibility$atemporal <- get_atemp_plausis(
  rv = rv,
  atemp_vars = rv$pl$atemp_vars,
  mdr = rv$mdr,
  headless = rv$headless
)

# add the plausibility raw data to data_target and data_source
for (i in names(rv$data_plausibility$atemporal)) {
  for (k in c("source_data", "target_data")) {
    w <- gsub("_data", "", k)
    raw_data <- paste0("data_", w)
    rv[[raw_data]][[i]] <-
      rv$data_plausibility$atemporal[[i]][[k]][[raw_data]]
    rv$data_plausibility$atemporal[[i]][[k]][[raw_data]] <- NULL
  }
  gc()
}

# calculate descriptive results
rv$results_descriptive <- descriptive_results(
  rv = rv,
  headless = rv$headless
)

# calculate unique plausibilites
uniq_plausi_results(
  rv = rv,
  uniq_vars = rv$pl$uniq_vars,
  mdr = rv$mdr,
  headless = rv$headless
)
}
}
