% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drdrtest.R
\name{drdrtest.base}
\alias{drdrtest.base}
\title{The base function for performing tests of average treatment effects}
\usage{
drdrtest.base(
  y,
  a,
  pi,
  varpi,
  mu,
  ma,
  arange,
  h = NULL,
  b = 1000,
  dist = "TwoPoint",
  a.grid.size = 401
)
}
\arguments{
\item{y}{A vector containing the outcomes for each observation}

\item{a}{A vector containing the treatment levels (dosage) for each observation}

\item{pi}{A vector containing the propensity scores for each observation}

\item{varpi}{A vector containing the mean propensity scores for each observation}

\item{mu}{A vector containing the outcome regression function values for each observation}

\item{ma}{A vector containing the mean outcome regression fucntion values for each observation}

\item{arange}{A vector of length 2 giving the lower bound and upper bound of  treatment levels}

\item{h}{bandwidth to be used in kernel regression. If not specified, will by default use "rule of thumb" bandwidth selector}

\item{b}{number of Bootstrap samples to be generated}

\item{dist}{distibution used to generate residuals for Bootstrap samples. Currently only have two options, "TwoPoint" and "Rademachar"}

\item{a.grid.size}{size of equally spaced grid points over \code{arange} to be generate for numerically evaluating the integral in test statistic}
}
\value{
A list containing \describe{
\item{p.value:}{P value of the test result}
\item{test.stat:}{Value of the observed test statistic}
\item{Bootstrap.samples:}{A vector containing test statistic values from Bootstrap samples}
\item{loc.fit:}{A list containg evalution points of average treatment effect and the corresponding values}
\item{bandwidth:}{Bandwidth used in kernel regression}
}
}
\description{
This is the base function for testing average treatment effects. Users can use specify the nuisance function values by themselves.
}
\examples{
mu.mod<-function(a,l,delta,height){
    mu <- as.numeric(l\%*\%c(0.2,0.2,0.3,-0.1))+triangle(a-2.5,delta,height)+a*(-0.1*l[,1]+0.1*l[,3])
    return(mu)
}
triangle <- function(a,delta,height){
    y <- exp(-a^2/((delta/2)^2))*height
    return(y)
}
set.seed(2000)
n <- 500
d <- 4
sigma <- 0.5
delta <- 1
height <- 0
arange<-c(0.01,4.99)

l <- matrix(rnorm(n*d),ncol=d)
colnames(l) <- paste("l",1:4,sep="")
logit.lambda <- as.numeric(l\%*\%c(0.1,0.1,-0.1,0.2))
lambda <- exp(logit.lambda)/(1+exp(logit.lambda))
a <- rbeta(n, shape1 = lambda, shape2 =1-lambda)*5

mu <- mu.mod(a,l,delta,height)
residual.list <- rnorm(n,mean=0,sd=sigma)
y <- mu+residual.list

## We use the oracal propensity score and outcome regression for illustration
pilist <- dbeta(a/5, shape1=lambda, shape2 = 1-lambda)/5
varpilist <- colMeans(matrix(dbeta(rep(a,each=n)/5,
                                   shape1=rep(lambda,n),
                                   shape2 = 1-rep(lambda,n))/5, nrow=n))
mulist <- mu
malist <-colMeans(matrix(mu.mod(rep(a,each=n),l[rep(1:n,n),],delta,height),nrow=n))

out <- drdrtest.base(y,a,pilist,varpilist,mulist,malist,arange)

}
