% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drdrtest.R
\name{drdrtest.superlearner}
\alias{drdrtest.superlearner}
\title{The function for performing tests of average treatment effects with SuperLearner}
\usage{
drdrtest.superlearner(
  y,
  a,
  l,
  arange,
  pi.sl.lib = c("SL.earth", "SL.glm", "SL.gam", "SL.glmnet"),
  mu.sl.lib = c("SL.earth", "SL.glm", "SL.gam", "SL.glmnet"),
  mu.family = "gaussian",
  h = NULL,
  b = 1000,
  dist = "TwoPoint",
  a.grid.size = 401,
  pi.low = 0.01,
  pi.var.low = 0.01
)
}
\arguments{
\item{y}{A vector containing the outcomes for each observation}

\item{a}{A vector containing the treatment levels (dosage) for each observation}

\item{l}{A data.frame containing the observations of covariates}

\item{arange}{A vector of length 2 giving the lower bound and upper bound of  treatment levels}

\item{pi.sl.lib}{Models will be used by SuperLearner to estiamte propensity scores}

\item{mu.sl.lib}{Models will be used by SuperLearner to estiamte outcome regression function}

\item{mu.family}{Type of response. Currently only support "gaussian" and "binomial"}

\item{h}{bandwidth to be used in kernel regression. If not specified, will by default use "rule of thumb" bandwidth selector}

\item{b}{number of Bootstrap samples to be generated}

\item{dist}{distibution used to generate residuals for Bootstrap samples. Currently only have two options, "TwoPoint" and "Rademachar"}

\item{a.grid.size}{size of equally spaced grid points over \code{arange} to be generate for numerically evaluating the integral in test statistic}

\item{pi.low}{Lower bound to truncate propensity scores}

\item{pi.var.low}{Lower bound to truncate conditional variance of treament (used in propensity score estimation).}
}
\value{
A list containing \describe{
\item{p.value:}{P value of the test result}
\item{test.stat:}{Value of the observed test statistic}
\item{Bootstrap.samples:}{A vector containing test statistic values from Bootstrap samples}
\item{loc.fit:}{A list containg evalution points of average treatment effect and the corresponding values}
\item{bandwidth:}{Bandwidth used in kernel regression}
}
}
\description{
This is the function for testing average treatment effects with user specified nuisance functions.
}
\examples{
mu.mod<-function(a,l,delta,height){
    mu <- as.numeric(l\%*\%c(0.2,0.2,0.3,-0.1))+triangle(a-2.5,delta,height)+a*(-0.1*l[,1]+0.1*l[,3])
    return(mu)
}
triangle <- function(a,delta,height){
    y <- exp(-a^2/((delta/2)^2))*height
    return(y)
}
set.seed(2000)
n <- 500
d <- 4
sigma <- 0.05
delta <- 1
height <- 0
arange<-c(0.01,4.99)

l <- matrix(rnorm(n*d),ncol=d)
colnames(l) <- paste("l",1:4,sep="")
logit.lambda <- as.numeric(l\%*\%c(0.1,0.1,-0.1,0.2))
lambda <- exp(logit.lambda)/(1+exp(logit.lambda))
a <- rbeta(n, shape1 = lambda, shape2 =1-lambda)*5

mu <- mu.mod(a,l,delta,height)
residual.list <- rnorm(n,mean=0,sd=sigma)
y <- mu+residual.list

out <- drdrtest.superlearner(y,a,l,arange,pi.sl.lib=c("SL.glm"),mu.sl.lib=c("SL.glm"))
}
