% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XgbPCFit.R
\name{XgbPCFit}
\alias{XgbPCFit}
\title{xgboost based power curve modelling}
\usage{
XgbPCFit(
  trainX,
  trainY,
  testX,
  max.depth = 8,
  eta = 0.25,
  nthread = 2,
  nrounds = 5
)
}
\arguments{
\item{trainX}{a matrix or dataframe to be used in modelling}

\item{trainY}{a numeric or vector as a target}

\item{testX}{a matrix or dataframe, to be used in computing the predictions}

\item{max.depth}{maximum depth of a tree}

\item{eta}{learning rate}

\item{nthread}{This parameter specifies the number of CPU threads that XGBoost}

\item{nrounds}{number of boosting rounds or trees to build}
}
\value{
a vector or numeric predictions on user provided test data
}
\description{
xgboost based power curve modelling
}
\examples{

data = data1
trainX = as.matrix(data[c(1:100),2])
trainY = data[c(1:100),7]
testX = as.matrix(data[c(101:110),2])

Xgb_prediction = XgbPCFit(trainX, trainY, testX)

}
\references{
Chen, T., & Guestrin, C. (2016). "XGBoost: A Scalable Tree Boosting System." Proceedings of the 22nd ACM SIGKDD International Conference on Knowledge Discovery and Data Mining, 785-794. \doi{10.1145/2939672.2939785}.
}
