% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTS.R
\name{ddts}
\alias{ddts}
\title{The probability mass function of the discrete tempered stable distribution.}
\usage{
ddts(x, alpha, eta, tp = c(1, 1), tf = "poisson-tweedie", zt = FALSE)
}
\arguments{
\item{x}{vector of points.}

\item{alpha}{Index of stability; Number in (0,1)}

\item{eta}{A parameter, eta>0.}

\item{tp}{A vector of tempering parameters.}

\item{tf}{Tempering function. It can be one of the "discrete-stable", "discrete-truncated-stable",
"discrete-pRDTS", "poisson-tweedie", "exp-tempering", "beta-prime-tempering", "Pareto-tempering".}

\item{zt}{Logical. If True it calculates zero-truncated probabilities.}
}
\value{
A vector of probabilities.
}
\description{
The probability mass function of the discrete tempered stable distribution.
}
\examples{
x <- 0:10
ddts(x, 0.5, 1)
}
\references{
M. Grabchak. Discrete tempered stable distributions. Methodology and Computing in Applied Probability, 24(3):1877-1890, 2021.
}
