% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dg2pop.R
\name{dg2pop}
\alias{dg2pop}
\title{Standardisation and decomposition of rates over K rate-factors and 2 populations.
We suggest using dgnpop, which will internally call this function.}
\usage{
dg2pop(pw, pop, factors, id_vars, ratefunction = NULL, quietly = TRUE)
}
\arguments{
\item{pw}{dataframe containing two populations worth of factor data, with columns specifying 1) population and 2) each rate-factor to be considered. must have column named "pop" indicating the population ID.}

\item{pop}{name (character string) of variable indicating population}

\item{factors}{names (character vector) of variables indicating compositional factors}

\item{id_vars}{character vector of variables indicating sub-populations}

\item{ratefunction}{user defined character string in R syntax that when evaluated specifies the function defining the rate as a function of factors. if NULL then will assume rate is the product of all factors.}

\item{quietly}{logical indicating whether interim messages should be outputted indicating progress through the P factors}
}
\value{
named list along set of K factors included in the standardisation. Each list element contains a data.frame that includes K-a standardised rates for each population, along with differences between standardised rates
}
\description{
Standardisation and decomposition of rates over K rate-factors and 2 populations.
We suggest using dgnpop, which will internally call this function.
}
