% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbReadTable,DatabaseConnectorConnection,character-method}
\alias{dbReadTable,DatabaseConnectorConnection,character-method}
\title{Read database tables as data frames}
\usage{
\S4method{dbReadTable}{DatabaseConnectorConnection,character}(conn, name, databaseSchema = NULL, ...)
}
\arguments{
\item{conn}{A \link[DBI:DBIConnection-class]{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{databaseSchema}{The name of the database schema. See details for platform-specific details.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbReadTable()} returns a data frame that contains the complete data
from the remote table, effectively the result of calling \code{\link[DBI:dbGetQuery]{dbGetQuery()}} with
\verb{SELECT * FROM <name>}.

An empty table is returned as a data frame with zero rows.

The presence of \link[DBI]{rownames} depends on the \code{row.names} argument,
see \code{\link[DBI:sqlColumnToRownames]{sqlColumnToRownames()}} for details:
\itemize{
\item If \code{FALSE} or \code{NULL}, the returned data frame doesn't have row names.
\item If \code{TRUE}, a column named "row_names" is converted to row names.
}

\itemize{
\item If \code{NA}, a column named "row_names" is converted to row names if it exists,
otherwise no translation occurs.
\item If a string, this specifies the name of the column in the remote table
that contains the row names.
}

The default is \code{row.names = FALSE}.

If the database supports identifiers with special characters,
the columns in the returned data frame are converted to valid R
identifiers
if the \code{check.names} argument is \code{TRUE},
If \code{check.names = FALSE}, the returned table has non-syntactic column names without quotes.
}
\description{
Reads a database table to a data frame, optionally converting
a column to row names and converting the column names to valid
R identifiers.
Use \code{\link[DBI:dbReadTableArrow]{dbReadTableArrow()}} instead to obtain an Arrow object.

}
\details{
The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.
}
\seealso{
Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbAppendTableArrow}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbCreateTableArrow}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbGetQueryArrow}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbReadTableArrow}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendQueryArrow}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbUnquoteIdentifier}()},
\code{\link[DBI]{dbWriteTable}()},
\code{\link[DBI]{dbWriteTableArrow}()}
}
