% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatastreamUserCreated_TimeSeries.R
\name{DSTimeSeriesDateInfo}
\alias{DSTimeSeriesDateInfo}
\title{DSTimeSeriesDateInfo}
\value{
DSTimeSeriesDateInfo object
}
\description{
This class is a supporting attribute for the DateInfo property of the DSTimeSeriesResponseObject.
It describes the basic range of data for the timeseries.

The DateRange property (DSTimeSeriesDateRange described above) of the DSTimeSeriesResponseObject always returns the
dates for a given frequency as the first date in each period
(e.g. 2022-01-01, 2020-04-01, etc. for quarterly frequencies). However, The StartDate and EndDate values returned
in this class for the DSTimeSeriesResponseObject reflect the start and end dates of the range of dates
that would be returned to users requesting the data via Datastream For Office, charting, etc.
This depends on the DateAlignment property (DSTimeSeriesDateAlignment) of the timeseries.
The start and end dates returned here will be either the start, mid or end dates for the set frequency
based on the DateAlignment property (see DSTimeSeriesDateAlignment).
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{StartDate}}{A datetime value defining the start date of the timeseries data}

\item{\code{EndDate}}{A datetime value defining the end date for the timeseries.}

\item{\code{Frequency}}{The frequency of the timeseries. One of the DSUserObjectFrequency values
defined in DSUserDataObjectBase.R}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DSTimeSeriesDateInfo-new}{\code{DSTimeSeriesDateInfo$new()}}
\item \href{#method-DSTimeSeriesDateInfo-clone}{\code{DSTimeSeriesDateInfo$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSTimeSeriesDateInfo-new"></a>}}
\if{latex}{\out{\hypertarget{method-DSTimeSeriesDateInfo-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSTimeSeriesDateInfo$new(jsonDict)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jsonDict}}{JSON dictionary (from JSON Response)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSTimeSeriesDateInfo object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSTimeSeriesDateInfo-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DSTimeSeriesDateInfo-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSTimeSeriesDateInfo$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
