% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooccur.R
\name{cooccur}
\alias{cooccur}
\title{Create a Code Co-occurrence Matrix and Network Plot}
\usage{
cooccur(
  excerpts = NULL,
  min_bold = 10,
  scale = c("count", "prop"),
  output = c("kable", "tibble", "data.frame"),
  plot = TRUE,
  edge_min = 10,
  layout = "circle",
  edge_color_low = "lightgray",
  edge_color_high = "purple",
  node_color = "lightblue",
  use_labels = FALSE,
  codebook = NULL
)
}
\arguments{
\item{excerpts}{Data frame containing coded excerpts, with a column named
\code{media_title} and code columns prefixed with \code{"c_"}.}

\item{min_bold}{Minimum value for bold highlighting in HTML table output (if
\code{output = "kable"}). Default is \code{10}.}

\item{scale}{Whether to display raw counts (\code{"count"}) or column-wise conditional
proportions (\code{"prop"}) in the returned matrix. The network plot always uses
raw counts. Default is \code{"count"}.}

\item{output}{The format of the co-occurrence matrix output. One of \code{"kable"},
\code{"tibble"}, or \code{"data.frame"}. Default is \code{"kable"}.}

\item{plot}{Logical; whether to produce a network visualization. Default is \code{TRUE}.}

\item{edge_min}{Minimum edge weight (in counts) for displaying connections in the plot.
Default is \code{10}.}

\item{layout}{Graph layout for network visualization (passed to \code{ggraph::ggraph}).
Common options include \code{"circle"}, \code{"fr"}, or \code{"kk"}. Default is \code{"circle"}.}

\item{edge_color_low, edge_color_high}{Color gradient for edge weights in the plot.
Default is \code{"lightgray"} to \code{"purple"}.}

\item{node_color}{Color for node points in the network plot. Default is \code{"lightblue"}.}

\item{use_labels}{Logical; if \code{TRUE}, replaces code variable names with descriptive
labels from a provided \code{codebook}. Default is \code{FALSE}.}

\item{codebook}{Optional data frame with columns:
\itemize{
\item \code{variable}: the code variable name (e.g., \code{"c_family"})
\item \code{label}: the descriptive name for the code (e.g., \code{"Family Connectedness"}).
Required when \code{use_labels = TRUE}.
}}
}
\value{
A named list with two elements:
\describe{
\item{matrix}{A tibble, data frame, or formatted HTML table of the co-occurrence matrix.}
\item{plot}{A \code{ggplot} object visualizing the co-occurrence network (if \code{plot = TRUE}).}
}
}
\description{
Builds a co-occurrence matrix showing how often qualitative codes appear together
within the same unit (e.g., transcript, document, or media title). The function
expects a coded dataset (\code{excerpts}) and returns both a formatted matrix and
(optionally) a network visualization. The returned matrix can be displayed as
raw counts or column-wise proportions, whereas the network plot always reflects
the underlying raw counts.
}
\details{
The function identifies columns beginning with \code{"c_"} as code variables.
It computes co-occurrences by summing pairwise intersections of codes across
all unique \code{media_title} units. The diagonal represents the marginal frequencies
(the number of transcripts where each code appears).

The resulting matrix can be output as a tibble, a simple data frame, or a
formatted HTML table via \code{knitr::kable}. If \code{plot = TRUE}, the function also
returns a network visualization of code co-occurrences using \code{ggraph} and \code{igraph}.
Edges are filtered via the \code{edge_min} threshold, and nodes without any remaining
connections are removed from the plot.
}
\examples{
# Example 1: Basic co-occurrence matrix from excerpts
df <- data.frame(
  media_title = c("Doc1", "Doc2", "Doc3"),
  c_hope = c(1, 0, 1),
  c_family = c(1, 1, 0),
  c_school = c(0, 1, 1)
)

result <- cooccur(
  excerpts = df,
  scale = "count",
  output = "tibble",
  plot = TRUE
)

result$matrix  # Co-occurrence matrix
result$plot    # Network plot

# Example 2: Use descriptive labels from a codebook and proportions in the table
codebook <- data.frame(
  variable = c("c_hope", "c_family", "c_school"),
  label = c("Hope & Optimism", "Family Connectedness", "School Belonging")
)

labeled_result <- cooccur(
  excerpts = df,
  use_labels = TRUE,
  codebook = codebook,
  scale = "prop",
  output = "kable",
  plot = TRUE
)

labeled_result$matrix
labeled_result$plot

}
