/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.undo.CannotUndoException;
import org.rosuda.JGR.DataLoader;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.browser.BrowserWindow;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.editor.FindReplaceDialog;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.toolkit.ConsoleOutput;
import org.rosuda.JGR.toolkit.DataTable;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.PrefDialog;
import org.rosuda.JGR.toolkit.SelectionPreservingCaret;
import org.rosuda.JGR.toolkit.SyntaxInput;
import org.rosuda.JGR.toolkit.ToolBar;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REngineException;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;
import org.rosuda.ibase.toolkit.WTentry;
import org.rosuda.ibase.toolkit.WinTracker;

public class JGRConsole
extends TJFrame
implements ActionListener,
KeyListener,
FocusListener,
RMainLoopCallbacks {
    private static final long serialVersionUID = 7379785188574795119L;
    private final JSplitPane consolePanel = new JSplitPane(0);
    public ConsoleOutput output = new ConsoleOutput();
    public SyntaxInput input = new SyntaxInput("console", true);
    public Document inputDoc = this.input.getDocument();
    public Document outputDoc = this.output.getDocument();
    public static final int MENUMODIFIER = Common.isMac() ? 4 : 2;
    private ToolBar toolBar;
    private String wspace = null;
    public int currentHistPosition = 0;
    private final StringBuffer console = new StringBuffer();
    private boolean wasHistEvent = false;
    public int end = 0;
    public static String guiEnv = "gui.working.env";
    public static String lastRPrompt = "> ";
    private Integer clearpoint = null;
    private int readCount = 0;

    public JGRConsole() {
        this(null);
    }

    public JGRConsole(File file) {
        super("Console", false, 1);
        Object object;
        Object object2;
        Serializable serializable;
        String[] stringArray = new String[]{"+", "File", "New Data", "newdata", "@LLoad Data", "loaddata", "-", "@NNew Document", "new", "@OOpen Document", "open", "!OSource File...", "source", "@SSave", "save", "-", "@DSet Working Directory", "setwd", "~File.Quit", "+", "Edit", "@ZUndo", "undo", "!ZRedo", "redo", "-", "@XCut", "cut", "@CCopy", "copy", "#Copy Special", "-", "@VPaste", "paste", "Delete", "delete", "@ASelect All", "selAll", "-", "@FFind", "search", "@GFind Next", "searchnext", "-", "!LClear Console", "clearconsole", "-", "!IIncrease Font Size", "fontBigger", "!DDecrease Font Size", "fontSmaller", "+", "Workspace", "Open", "openwsp", "Save", "savewsp", "Save as...", "saveaswsp", "-", "Clear All", "clearwp", "+", "Packages & Data", "@BObject Browser", "objectmgr", "Data Table", "table", "-", "Package Manager", "packagemgr", "Package Installer", "packageinst", "~Window", "+", "Help", "R Help", "help", "~Preferences", "~About", "0"};
        JMenuBar jMenuBar = EzMenuSwing.getEzMenu((JFrame)((Object)this), (ActionListener)this, (String[])stringArray);
        JMenu jMenu = (JMenu)EzMenuSwing.getItem((JFrame)((Object)this), (String)"Copy Special");
        if (jMenu != null) {
            serializable = new JMenuItem("Copy Output");
            ((AbstractButton)serializable).setActionCommand("copyoutput");
            ((AbstractButton)serializable).addActionListener(this);
            jMenu.add((JMenuItem)serializable);
            object2 = new JMenuItem("Copy Commands");
            ((AbstractButton)object2).setActionCommand("copycmds");
            ((AbstractButton)object2).addActionListener(this);
            jMenu.add((JMenuItem)object2);
            object = new JMenuItem("Copy Result");
            ((AbstractButton)object).setActionCommand("copyresult");
            ((AbstractButton)object).addActionListener(this);
            jMenu.add((JMenuItem)object);
        }
        if (!Common.isMac()) {
            EzMenuSwing.addMenuSeparator((JFrame)((Object)this), (String)"Edit");
            EzMenuSwing.addJMenuItem((JFrame)((Object)this), (String)"Edit", (String)"Preferences", (String)"preferences", (ActionListener)this);
            EzMenuSwing.addJMenuItem((JFrame)((Object)this), (String)"Help", (String)"About", (String)"about", (ActionListener)this);
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                if (jMenuBar.getMenu(i).getText().equals("Preferences") || jMenuBar.getMenu(i).getText().equals("About")) {
                    jMenuBar.remove(i);
                    --i;
                }
                if (!jMenuBar.getMenu(i).getText().equals("Edit")) continue;
                object2 = (JMenuItem)jMenuBar.getMenu(i).getMenuComponent(jMenuBar.getMenu(i).getMenuComponentCount() - 1);
                ((JMenuItem)object2).setAccelerator(KeyStroke.getKeyStroke(44, MENUMODIFIER));
            }
        }
        try {
            serializable = this.getClass().getResource("/icons/JGR.png");
            if (serializable != null) {
                object2 = Toolkit.getDefaultToolkit();
                object = ((Toolkit)object2).createImage((URL)serializable);
                this.getFrame().setIconImage((Image)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (JGR.RHISTORY == null) {
            JGR.RHISTORY = new Vector();
        }
        this.currentHistPosition = JGR.RHISTORY.size();
        this.toolBar = new ToolBar(this, true);
        this.input.addKeyListener(this);
        this.input.setWordWrap(false);
        this.input.addFocusListener(this);
        this.inputDoc.addUndoableEditListener(this.toolBar.undoMgr);
        this.input.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.output.setEditable(false);
        this.output.addFocusListener(this);
        this.output.addKeyListener(this);
        this.output.setDragEnabled(true);
        this.output.setCaret(new SelectionPreservingCaret());
        this.output.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        serializable = new JScrollPane(this.output);
        ((JScrollPane)serializable).setVerticalScrollBarPolicy(22);
        this.consolePanel.setTopComponent((Component)serializable);
        object2 = new JScrollPane(this.input);
        ((JScrollPane)object2).setVerticalScrollBarPolicy(22);
        this.consolePanel.setBottomComponent((Component)object2);
        this.consolePanel.setDividerLocation((int)((double)this.getHeight() * 0.65));
        this.consolePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.consolePanel.setDividerSize(5);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n;
                super.componentResized(componentEvent);
                if (JGR.getREngine() != null && JGR.STARTED && (n = JGRConsole.this.getFontWidth()) > 0) {
                    JGR.threadedEval("options(width=" + n + ")");
                }
                JGRConsole.this.consolePanel.setDividerLocation((int)((double)JGRConsole.this.getHeight() * 0.7));
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JGRConsole.this.dispose();
            }
        });
        this.addKeyListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.consolePanel, "Center");
        this.setMinimumSize(new Dimension(555, 650));
        this.setSize(new Dimension(JGRPrefs.consoleWidth, Common.screenRes.height < JGRPrefs.consoleHeight ? Common.screenRes.height - 50 : JGRPrefs.consoleHeight));
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.input.mComplete.setVisible(false);
        new Thread(new Refresher()).start();
    }

    public void exit() {
        Enumeration enumeration = WinTracker.current.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (wTentry.wclass != 150 || ((Editor)((Object)wTentry.w)).exit()) continue;
            return;
        }
        this.execute("q()", false);
    }

    public void dispose() {
        Enumeration enumeration = WinTracker.current.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (wTentry.wclass != 150 || ((Editor)((Object)wTentry.w)).exit()) continue;
            return;
        }
        this.execute("q()", false);
    }

    public void execute(String string) {
        this.execute(string, true);
    }

    public void execute(String string, boolean bl) {
        if (!JGR.STARTED) {
            return;
        }
        if (bl && JGR.RHISTORY.size() == 0) {
            JGR.RHISTORY.add(string);
        } else if (bl && string.trim().length() > 0 && JGR.RHISTORY.size() > 0 && !JGR.RHISTORY.lastElement().equals(string.trim())) {
            JGR.RHISTORY.add(string);
        }
        this.currentHistPosition = JGR.RHISTORY.size();
        final String[] stringArray = string.split("\n");
        new Thread(new Runnable(){

            public void run() {
                String string = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    string = stringArray[i];
                    if (!JGRConsole.this.isSupported(string)) continue;
                    String string2 = string;
                    JGR.rSync.triggerNotification(string2.trim());
                }
            }
        }).start();
    }

    public String getUniqueName(String string) {
        JGR.refreshObjects();
        string = RController.makeValidVariableName(string);
        if (!JGR.OBJECTS.contains(string)) {
            return string;
        }
        int n = 1;
        while (JGR.OBJECTS.contains(string + n)) {
            ++n;
        }
        return string + n;
    }

    public String getUniqueName(String string, String string2) {
        string = RController.makeValidVariableName(string);
        try {
            REXPLogical rEXPLogical = (REXPLogical)JGR.eval("is.environment(" + string2 + ")");
            boolean bl = rEXPLogical.isTRUE()[0];
            if (!bl) {
                return string;
            }
        }
        catch (REngineException rEngineException) {
            new ErrorMsg(rEngineException);
            return string;
        }
        catch (REXPMismatchException rEXPMismatchException) {
            new ErrorMsg(rEXPMismatchException);
            return string;
        }
        boolean bl = false;
        try {
            REXPLogical rEXPLogical = (REXPLogical)JGR.eval("exists('" + string + "',where=" + string2 + ",inherits=FALSE)");
            bl = rEXPLogical.isFALSE()[0];
            if (bl) {
                return string;
            }
        }
        catch (REngineException rEngineException) {
            new ErrorMsg(rEngineException);
            return string;
        }
        catch (REXPMismatchException rEXPMismatchException) {
            new ErrorMsg(rEXPMismatchException);
            return string;
        }
        int n = 1;
        while (true) {
            try {
                REXPLogical rEXPLogical = (REXPLogical)JGR.eval("exists('" + string + n + "',where=" + string2 + ",inherits=FALSE)");
                bl = rEXPLogical.isFALSE()[0];
            }
            catch (REngineException rEngineException) {
                new ErrorMsg(rEngineException);
            }
            catch (REXPMismatchException rEXPMismatchException) {
                new ErrorMsg(rEXPMismatchException);
            }
            if (bl) {
                return string + n;
            }
            ++n;
        }
    }

    private boolean isSupported(String string) {
        if ((string = string.trim()).startsWith("fix(") || string.startsWith("edit(") || string.startsWith("edit.data.frame(")) {
            try {
                this.output.append(string + "\n", JGRPrefs.CMD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.output.append("Editing is not supported yet!", JGRPrefs.RESULT);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.output.append("\n" + RController.getRPrompt(), JGRPrefs.CMD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public void clearconsole() {
        try {
            if (this.end > 0 && this.clearpoint == null) {
                this.clearpoint = new Integer(this.output.getLineEndOffset(this.output.getLineOfOffset(this.end) - 1) + 2);
            }
            if (this.clearpoint != null) {
                this.output.removeAllFrom(this.clearpoint);
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void loadWorkSpace() {
        FileSelector fileSelector = new FileSelector((Frame)((Object)this), "Open Workspace", 0);
        fileSelector.setVisible(true);
        if (fileSelector.getFile() != null) {
            JGRPrefs.workingDirectory = fileSelector.getDirectory();
            this.wspace = JGRPrefs.workingDirectory + fileSelector.getFile();
            this.execute("load(\"" + this.wspace.replace('\\', '/') + "\")");
        }
    }

    public void saveWorkSpace(String string) {
        if (string == null) {
            this.execute("save.image()");
        } else {
            this.execute("save.image(\"" + (string == null ? "" : string.replace('\\', '/')) + "\",compress=TRUE)");
        }
        JGR.writeHistory();
    }

    public void saveWorkSpaceAs() {
        FileSelector fileSelector = new FileSelector((Frame)((Object)this), "Save Workspace as...", 1);
        fileSelector.setVisible(true);
        if (fileSelector.getFile() != null) {
            JGRPrefs.workingDirectory = fileSelector.getDirectory();
            String string = JGRPrefs.workingDirectory + fileSelector.getFile();
            this.saveWorkSpace(string);
            JGR.writeHistory();
        }
    }

    public int getFontWidth() {
        int n = this.output.getFontMetrics(this.output.getFont()).charWidth('M');
        n = this.output.getWidth() / n;
        return n - (JGRPrefs.isMac ? 0 : 1);
    }

    public void rWriteConsole(Rengine rengine, String string, int n) {
        if (this.readCount == 2) {
            this.end = this.output.getText().length();
            this.readCount = 3;
        }
        final String string2 = string;
        Runnable runnable = new Runnable(){

            public void run() {
                JGRConsole.this.console.append(string2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void rWriteConsole(Rengine rengine, String string) {
        this.rWriteConsole(rengine, string, 0);
    }

    public void rBusy(Rengine rengine, int n) {
        final int n2 = n;
        Runnable runnable = new Runnable(){

            public void run() {
                if (n2 == 0) {
                    JGRConsole.this.setWorking(false);
                } else {
                    ((JGRConsole)JGRConsole.this).toolBar.stopButton.setEnabled(true);
                    JGRConsole.this.setWorking(true);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public String rReadConsole(Rengine rengine, String string, int n) {
        if (this.readCount < 2) {
            ++this.readCount;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                ((JGRConsole)JGRConsole.this).toolBar.stopButton.setEnabled(false);
            }
        };
        SwingUtilities.invokeLater(runnable);
        if (string.indexOf("Save workspace") > -1) {
            String string2 = JGR.exit();
            if (this.wspace != null && string2.indexOf(121) >= 0) {
                try {
                    JGR.getREngine().eval(new REXPString("save.image(\"" + this.wspace.replace('\\', '/') + "\")"), null, false);
                }
                catch (REngineException rEngineException) {
                    new ErrorMsg(rEngineException);
                }
                catch (REXPMismatchException rEXPMismatchException) {
                    new ErrorMsg(rEXPMismatchException);
                }
                return "n\n";
            }
            return string2;
        }
        lastRPrompt = string;
        final String string3 = string;
        Runnable runnable2 = new Runnable(){

            public void run() {
                String string;
                if (JGRConsole.this.console.length() > 0) {
                    JGRConsole.this.output.append(JGRConsole.this.console.toString(), JGRPrefs.RESULT);
                    JGRConsole.this.console.delete(0, JGRConsole.this.console.length());
                    JGRConsole.this.output.setCaretPosition(JGRConsole.this.outputDoc.getLength());
                }
                if ((string = JGRConsole.this.output.getLine(JGRConsole.this.output.getLineCount() - 1)) != null && string.length() > 0) {
                    JGRConsole.this.output.append("\n", JGRPrefs.RESULT);
                }
                JGRConsole.this.output.append(string3, JGRPrefs.CMD);
                JGRConsole.this.output.setCaretPosition(JGRConsole.this.outputDoc.getLength());
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        final String string4 = JGR.rSync.waitForNotification();
        Runnable runnable3 = new Runnable(){

            public void run() {
                try {
                    JGRConsole.this.output.append(string4 + "\n", JGRPrefs.CMD);
                    if (JGRConsole.this.console.length() > 0) {
                        JGRConsole.this.output.append(JGRConsole.this.console.toString(), JGRPrefs.RESULT);
                        JGRConsole.this.console.delete(0, JGRConsole.this.console.length());
                        JGRConsole.this.output.setCaretPosition(JGRConsole.this.outputDoc.getLength());
                    }
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string4 == null || string4.length() == 0 ? "\n" : string4 + "\n";
    }

    public void rShowMessage(Rengine rengine, String string) {
        JOptionPane.showMessageDialog((Component)((Object)this), string, "R Message", 1);
    }

    public String rChooseFile(Rengine rengine, int n) {
        FileSelector fileSelector = new FileSelector((Frame)((Object)this), n == 0 ? "Select a file" : "Select a new file", n == 0 ? 0 : 1);
        fileSelector.setVisible(true);
        String string = null;
        if (fileSelector.getDirectory() != null && fileSelector.getFile() != null) {
            string = fileSelector.getDirectory();
        }
        if (fileSelector.getFile() != null) {
            string = string == null ? fileSelector.getFile() : string + fileSelector.getFile();
        }
        return string;
    }

    public void rFlushConsole(Rengine rengine) {
    }

    public void rLoadHistory(Rengine rengine, String string) {
        File file = null;
        try {
            file = new File(string);
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                if (JGR.RHISTORY == null) {
                    JGR.RHISTORY = new Vector();
                }
                while (bufferedReader.ready()) {
                    JGR.RHISTORY.add(bufferedReader.readLine() + "\n");
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void rSaveHistory(Rengine rengine, String string) {
        try {
            File file = new File(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            Enumeration enumeration = JGR.RHISTORY.elements();
            while (enumeration.hasMoreElements()) {
                bufferedWriter.write(enumeration.nextElement().toString() + "#\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "about") {
            new AboutDialog((JFrame)((Object)this));
        } else if (string == "cut") {
            this.input.cut();
        } else if (string == "clearwsp") {
            this.execute("rm(list=ls())", false);
        } else if (string == "copy") {
            this.input.copy();
            this.output.copy();
        } else if (string == "copyoutput") {
            this.output.copyOutput();
        } else if (string != "print") {
            if (string == "copycmds") {
                this.output.copyCommands();
            } else if (string == "copyresult") {
                this.output.copyResults();
            } else if (string == "clearconsole") {
                this.clearconsole();
            } else if (string == "delete") {
                try {
                    int n = 0;
                    n = this.input.getSelectionStart();
                    this.inputDoc.remove(n, this.input.getSelectionEnd() - n);
                }
                catch (BadLocationException badLocationException) {}
            } else if (string == "editor") {
                new Editor();
            } else if (string == "exit") {
                this.dispose();
            } else if (string == "exportOutput") {
                this.output.startExport();
            } else if (string == "fontBigger") {
                FontTracker.current.setFontBigger();
            } else if (string == "fontSmaller") {
                FontTracker.current.setFontSmaller();
            } else if (string == "newdata") {
                String string2 = JOptionPane.showInputDialog("Data Name: ");
                if (string2 != null) {
                    this.execute(string2.trim() + "<-data.frame()");
                }
            } else if (string == "loaddata") {
                new DataLoader();
            } else if (string == "open") {
                Editor editor = new Editor(null, false);
                editor.open();
            } else if (string == "openwsp") {
                this.loadWorkSpace();
            } else if (string == "new") {
                new Editor();
            } else if (string == "objectmgr") {
                Point point = this.getLocationOnScreen();
                int n = this.getWidth();
                BrowserWindow browserWindow = new BrowserWindow();
                browserWindow.setLocation(Math.min(point.x + n, Common.screenRes.width - 200), Math.min(Common.screenRes.height - 200, point.y));
                browserWindow.setVisible(true);
            } else if (string == "packagemgr") {
                this.execute("JGR::package.manager()", false);
            } else if (string == "packageinst") {
                this.execute("installPackages()", false);
            } else if (string == "paste") {
                this.input.paste();
            } else if (string == "preferences") {
                PrefDialog prefDialog = PrefDialog.showPreferences((JFrame)((Object)this));
                prefDialog.setLocationRelativeTo(null);
                prefDialog.setVisible(true);
            } else if (string == "redo") {
                try {
                    if (this.toolBar.undoMgr.canRedo()) {
                        this.toolBar.undoMgr.redo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {}
            } else if (string == "help") {
                this.execute("help.start()");
            } else if (string == "table") {
                new DataTable(null, null, true);
            } else if (string == "save") {
                this.output.startExport();
            } else if (string == "savewsp") {
                this.saveWorkSpace(this.wspace);
            } else if (string == "saveaswsp") {
                this.saveWorkSpaceAs();
            } else if (string == "clearwp") {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you wish to clear your workspace?\nAll unsaved objects will be deleted.", "Clear Workspace", 0);
                if (n == 0) {
                    this.execute("rm(list=ls())");
                }
            } else if (string == "search") {
                FindReplaceDialog.findExt((Frame)((Object)this), this.output);
            } else if (string == "searchnext") {
                FindReplaceDialog.findNextExt((Frame)((Object)this), this.output);
            } else if (string == "source") {
                this.execute("source(file.choose())", false);
            } else if (string == "stop") {
                try {
                    new Thread(new Runnable(){

                        public void run() {
                            ((JRIEngine)JGR.getREngine()).getRni().rniStop(0);
                        }
                    }).start();
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                }
            } else if (string == "selAll") {
                if (this.input.isFocusOwner()) {
                    this.input.selectAll();
                } else if (this.output.isFocusOwner()) {
                    this.output.selectAll();
                }
            } else if (string == "undo") {
                try {
                    if (this.toolBar.undoMgr.canUndo()) {
                        this.toolBar.undoMgr.undo();
                    }
                }
                catch (Exception exception) {}
            } else if (string == "setwd") {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setDialogTitle("Choose Working Directory");
                jFileChooser.setApproveButtonText("Choose");
                int n = jFileChooser.showOpenDialog((Component)((Object)this));
                if (n == 1) {
                    return;
                }
                if (jFileChooser.getSelectedFile() != null) {
                    JGRPrefs.workingDirectory = jFileChooser.getSelectedFile().toString();
                }
                this.execute("setwd(\"" + jFileChooser.getSelectedFile().toString().replace('\\', '/') + "\")");
            } else if (string == "update") {
                this.execute("update.JGR(contriburl=\"http://rosuda.org/R/nightly\")", false);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(this.output) && !keyEvent.isMetaDown() && !keyEvent.isControlDown() && !keyEvent.isAltDown()) {
            this.input.requestFocus();
        }
        if (keyEvent.getKeyCode() == 38) {
            if (this.input.mComplete != null && this.input.mComplete.isVisible()) {
                this.input.mComplete.selectPrevious();
            } else if (this.currentHistPosition > 0 && (this.input.getCaretPosition() == 0 || this.input.getCaretPosition() == this.input.getText().length())) {
                this.input.setText(JGR.RHISTORY.get(--this.currentHistPosition).toString());
                this.input.setCaretPosition(this.input.getText().length());
                this.wasHistEvent = true;
            }
        } else if (keyEvent.getKeyCode() == 40) {
            if (this.input.mComplete != null && this.input.mComplete.isVisible()) {
                this.input.mComplete.selectNext();
            } else if (this.input.getCaretPosition() == 0 || this.input.getCaretPosition() == this.input.getText().length()) {
                if (this.currentHistPosition < JGR.RHISTORY.size() - 1) {
                    this.input.setText(JGR.RHISTORY.get(++this.currentHistPosition).toString());
                    this.input.setCaretPosition(this.input.getText().length());
                } else if (JGR.RHISTORY.size() > 0 && this.currentHistPosition < JGR.RHISTORY.size()) {
                    this.input.setText("");
                    ++this.currentHistPosition;
                }
                this.wasHistEvent = true;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (this.input.mComplete != null && this.input.mComplete.isVisible() && !keyEvent.isControlDown() && !keyEvent.isMetaDown()) {
                this.input.mComplete.completeCommand();
            } else if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                try {
                    this.inputDoc.insertString(this.input.getCaretPosition(), "\n", null);
                    this.input.mComplete.setVisible(false);
                }
                catch (Exception exception) {}
            } else {
                String string = this.input.getText().trim();
                this.input.setText("");
                this.input.setCaretPosition(0);
                this.input.requestFocus();
                this.execute(string);
            }
        }
        if (keyEvent.getSource().equals(this.output) && keyEvent.getKeyCode() == 86 && (keyEvent.isControlDown() || keyEvent.isMetaDown())) {
            this.input.requestFocus();
            this.input.paste();
            this.input.setCaretPosition(this.input.getText().length());
        } else if ((keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) && this.wasHistEvent) {
            this.wasHistEvent = false;
            this.input.setCaretPosition(this.input.getText().length());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.output)) {
            this.toolBar.cutButton.setEnabled(false);
            EzMenuSwing.getItem((JFrame)((Object)this), (String)"cut").setEnabled(false);
            this.toolBar.pasteButton.setEnabled(false);
            EzMenuSwing.getItem((JFrame)((Object)this), (String)"paste").setEnabled(false);
        } else if (focusEvent.getSource().equals(this.input)) {
            this.toolBar.cutButton.setEnabled(true);
            EzMenuSwing.getItem((JFrame)((Object)this), (String)"cut").setEnabled(true);
            this.toolBar.pasteButton.setEnabled(true);
            EzMenuSwing.getItem((JFrame)((Object)this), (String)"paste").setEnabled(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public PrintStream getStdOutPrintStream() {
        MutableAttributeSet mutableAttributeSet = JGRPrefs.RESULT;
        return this.getPrintStream(mutableAttributeSet);
    }

    private PrintStream getPrintStream(final MutableAttributeSet mutableAttributeSet) {
        OutputStream outputStream = new OutputStream(){

            public void write(int n) throws IOException {
                JGRConsole.this.output.append(String.valueOf((char)n), mutableAttributeSet);
            }
        };
        PrintStream printStream = new PrintStream(outputStream);
        return printStream;
    }

    public PrintStream getStdErrPrintStream() {
        MutableAttributeSet mutableAttributeSet = JGRPrefs.RESULT;
        return this.getPrintStream(mutableAttributeSet);
    }

    class Refresher
    implements Runnable {
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        Runnable runnable = new Runnable(){

                            public void run() {
                                if (JGRConsole.this.console.length() > 0) {
                                    String string = ((Refresher)Refresher.this).JGRConsole.this.output.getLine(((Refresher)Refresher.this).JGRConsole.this.output.getLineCount() - 1);
                                    if (string != null && string.equals(lastRPrompt)) {
                                        ((Refresher)Refresher.this).JGRConsole.this.output.append("\n", JGRPrefs.CMD);
                                    }
                                    ((Refresher)Refresher.this).JGRConsole.this.output.append(JGRConsole.this.console.toString(), JGRPrefs.RESULT);
                                    JGRConsole.this.console.delete(0, JGRConsole.this.console.length());
                                    ((Refresher)Refresher.this).JGRConsole.this.output.setCaretPosition(((Refresher)Refresher.this).JGRConsole.this.outputDoc.getLength());
                                }
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                    continue;
                }
                break;
            }
        }
    }
}

