/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.rosuda.deducer.plots.AesWidget;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;

public class DefaultElementView
extends ElementView {
    protected JScrollPane scroller;
    protected JPanel paramPanel;
    protected ElementModel model;
    protected Vector widgets = new Vector();

    public DefaultElementView() {
        this.initGui();
    }

    public DefaultElementView(ElementModel elementModel) {
        this.initGui();
        this.setModel(elementModel);
    }

    private void initGui() {
        this.setLayout(new BorderLayout());
        this.scroller = new JScrollPane();
        this.scroller.setHorizontalScrollBarPolicy(31);
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.scroller.setBorder(border);
        this.add(this.scroller);
        this.paramPanel = new JPanel();
        this.scroller.setViewportView(this.paramPanel);
    }

    public void updatePanel() {
        this.paramPanel.removeAll();
        BoxLayout boxLayout = new BoxLayout(this.paramPanel, 1);
        this.paramPanel.setLayout(boxLayout);
        for (int i = 0; i < this.model.getParams().size(); ++i) {
            Param param = (Param)this.model.getParams().get(i);
            ParamWidget paramWidget = param.getView();
            paramWidget.setAlignmentX(0.5f);
            paramWidget.setMaximumSize(new Dimension(365, paramWidget.getMaximumSize().height));
            this.widgets.add(paramWidget);
            this.paramPanel.add(paramWidget);
            this.paramPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        this.paramPanel.validate();
        this.paramPanel.repaint();
    }

    @Override
    public ElementModel getModel() {
        this.updateModel();
        return this.model;
    }

    @Override
    public void setModel(ElementModel elementModel) {
        this.model = elementModel;
        this.updatePanel();
    }

    @Override
    public void updateModel() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            Object e = this.widgets.get(i);
            if (e instanceof AesWidget) {
                ((AesWidget)e).updateModel();
                continue;
            }
            if (!(e instanceof ParamWidget)) continue;
            ((ParamWidget)e).updateModel();
        }
    }
}

