% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelativeRep.R
\name{RelativeRepresentation}
\alias{RelativeRepresentation}
\title{Compute relative representation compared to random sampling}
\usage{
RelativeRepresentation(BodyMemberCharacteristics,
                       PopShares,
                       a = -0.5, b = 1,
                       standardize = FALSE,
                       nMonte = 10000)
}
\arguments{
\item{BodyMemberCharacteristics}{A vector specifying characteristics for each
member of a political body.}

\item{PopShares}{A numeric vector of population group proportions. Names must
correspond to identities in \code{BodyMemberCharacteristics}.}

\item{a, b}{Parameters controlling the affine transformation of the
representation index, passed to \code{ObservedRepresentation} and
\code{ExpectedRepresentation}.}

\item{standardize}{Logical. If \code{TRUE}, the difference between observed and
expected representation is divided by the standard deviation of representation
under random sampling.}

\item{nMonte}{A positive integer denoting number of Monte Carlo iterations used
for estimating the standard deviation when \code{standardize = TRUE}.}
}
\value{
A scalar giving the difference between observed and expected
representation. If \code{standardize = TRUE}, the difference is divided by the
standard deviation under the random sampling model.
}
\description{
Calculates the difference between observed and expected representation.
Optionally standardizes this difference using the standard deviation of
representation under the random sampling model.
}
\seealso{
\code{\link{ObservedRepresentation}},
\code{\link{ExpectedRepresentation}},
\code{\link{SDRepresentation}}
}
