% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{expand.grids}
\alias{expand.grids}
\title{Create a Data Frame from all combinations of factor variables}
\usage{
expand.grids(d = length(list(...)), ...)
}
\arguments{
\item{d}{number of variables (taken in following arguments with modulo)}

\item{...}{variables to combine, as arrays of values}
}
\value{
data frame of all possible combinations of variables values
}
\description{
Generalization of base::expand.grid to more than 2 variables.
}
\examples{
expand.grids(d=1)
expand.grids(d=1,seq(f=0,t=1,l=11))
expand.grids(d=2)
expand.grids(d=2,seq(f=0,t=1,l=11))
expand.grids(d=2,seq(f=0,t=1,l=11),seq(0,1,l=3))
expand.grids(d=3,seq(f=0,t=1,l=5))
expand.grids(d=NULL,seq(f=0,t=1,l=5),seq(f=0,t=1,l=5),seq(f=0,t=1,l=5))
expand.grids(seq(f=0,t=1,l=5),seq(f=0,t=1,l=5),seq(f=0,t=1,l=5))
expand.grids(d=4,seq(f=0,t=1,l=5))
}
