% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{intestinal_smartpill_df}
\alias{intestinal_smartpill_df}
\title{SmartPill Intestinal Transit}
\format{
A data frame with 95 observations and 22 variables:
\describe{
  \item{Group}{Numeric indicator of group membership}
  \item{Gender}{Numeric indicator of gender}
  \item{Race}{Numeric code indicating racial background}
  \item{Height}{Height in centimeters}
  \item{Weight}{Weight in kilograms}
  \item{Age}{Age in years}
  \item{GE.Time}{Gastric emptying time (minutes)}
  \item{SB.Time}{Small bowel transit time (minutes)}
  \item{C.Time}{Colon transit time (minutes)}
  \item{WG.Time}{Whole gut transit time (minutes)}
  \item{S.Contractions}{Number of contractions in the stomach}
  \item{S.Sum.of.Amplitudes}{Sum of contraction amplitudes in the stomach}
  \item{S.Mean.Peak.Amplitude}{Mean peak amplitude in the stomach}
  \item{S.Mean.pH}{Mean pH level in the stomach}
  \item{SB.Contractions}{Number of contractions in the small bowel}
  \item{SB.Sum.of.Amplitudes}{Sum of contraction amplitudes in the small bowel}
  \item{SB.Mean.Peak.Amplitude}{Mean peak amplitude in the small bowel}
  \item{SB.Mean.pH}{Mean pH level in the small bowel}
  \item{Colon.Contractions}{Number of contractions in the colon}
  \item{Colon.Sum.of.Amplitudes}{Sum of contraction amplitudes in the colon}
  \item{C.Mean.Peak.Amplitude}{Mean peak amplitude in the colon}
  \item{C.Mean.pH}{Mean pH level in the colon}
}
}
\source{
Data taken from the \pkg{medicaldata} package version 0.2.0. Original source: Rauch et al.,
"Use of Wireless Utility Capsule to Determine Gastric Emptying and Small Intestinal Transit Times in Critically Ill Trauma Patients".
\emph{Journal of Critical Care}, 2012; 27(5): 534.e7--534.e12.
}
\usage{
data(intestinal_smartpill_df)
}
\description{
This dataset, intestinal_smartpill_df, is a data frame from a prospective cohort study
evaluating gastric emptying, small bowel transit time, and total intestinal transit time using
a SmartPill motility capsule. The study involved 8 critically ill trauma patients and 87 healthy
volunteers. The capsule wirelessly transmitted pH, pressure, and temperature to a recorder
attached to each subject's abdomen.
}
\details{
The dataset name has been kept as 'intestinal_smartpill_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
DigestiveDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
