% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telescope_match.R
\name{boots_tm}
\alias{boots_tm}
\title{Bootstrap Uncertainty Estimates for Telescope Matching}
\usage{
boots_tm(obj, boots = 1000, ci_alpha = 0.05)
}
\arguments{
\item{obj}{A \code{tmatch} object, computed by \code{\link{telescope_match}}.}

\item{boots}{The number of bootstrap replicates. Defaults to 1000.}

\item{ci_alpha}{alpha value for the bootstrapped confidence
intervals. Corresponds to a 100 * (1-alpha) confidence interval.}
}
\value{
An data.frame with columns `ci_low` and `ci_high` which
contain the bootstrapped confidence intervals for the estimated
ACDEs in \code{obj$tau}.
}
\description{
Performs a weighted bootstrap procedure for the output of
\code{\link{telescope_match}}.
}
\examples{
\donttest{
data(jobcorps)

## Split male/female
jobcorps_female <- subset(jobcorps, female == 1)

## Telescope matching formula - First stage (X and Z)
tm_form <- exhealth30 ~  schobef + trainyrbef + jobeverbef  |
treat | emplq4 + emplq4full | work2year2q


### Estimate ACDE for women holding employment at 0
tm_out <-  telescope_match(
  tm_form,
  data = jobcorps_female,
  L = 3,
  boot = FALSE,
  verbose = TRUE
)

out.boots <- boots_tm(tm_out)

out.boots
}
}
