% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompNBinom.R
\name{CompNBinom}
\alias{CompNBinom}
\alias{pCompNBinom}
\alias{expValCompNBinom}
\alias{varCompNBinom}
\alias{VatRCompNBinom}
\alias{TVatRCompNBinom}
\title{Compound Negative Binomial Distribution}
\usage{
pCompNBinom(
  x,
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  k0,
  distr_severity = "Gamma"
)

expValCompNBinom(
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  distr_severity = "Gamma"
)

varCompNBinom(
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  distr_severity = "Gamma"
)

VatRCompNBinom(
  kap,
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  k0,
  distr_severity = "Gamma"
)

TVatRCompNBinom(
  kap,
  vark,
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  k0,
  distr_severity = "Gamma"
)
}
\arguments{
\item{x}{vector of quantiles}

\item{size}{Number of successful trials.}

\item{prob}{Probability of success in each trial.}

\item{shape}{shape parameter \eqn{\alpha}{alpha}, must be positive.}

\item{rate}{rate parameter \eqn{\beta}{beta}, must be positive.}

\item{scale}{alternative parameterization to the rate parameter, scale = 1 / rate.}

\item{k0}{point up to which to sum the distribution for the approximation.}

\item{distr_severity}{Choice of severity distribution.
\itemize{
 \item{"gamma"} (default)
 \item{"lognormal"} only for the expected value and variance.
}}

\item{kap}{probability.}

\item{vark}{Value-at-Risk (VaR) calculated at the given probability kap.}
}
\value{
Function :
  \itemize{
    \item \code{\link{pCompNBinom}}  gives the cumulative density function.
    \item \code{\link{expValCompNBinom}}  gives the expected value.
    \item \code{\link{varCompNBinom}}  gives the variance.
    \item \code{\link{TVatRCompNBinom}}  gives the Tail Value-at-Risk.
    \item \code{\link{VatRCompNBinom}}  gives the Value-at-Risk.
  }
Returned values are approximations for the cumulative density function,
TVatR, and VatR.
}
\description{
Computes various risk measures (mean, variance, Value-at-Risk (VatR),
and Tail Value-at-Risk (TVatR)) for the compound Negative Binomial
distribution.
}
\details{
The compound negative binomial distribution has density ....
}
\examples{
pCompNBinom(x = 2, size = 1, prob = 0.2, shape = log(1000) - 0.405,
          rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")


expValCompNBinom(size = 4, prob = 0.2, shape = 0, scale = 1,
         distr_severity = "Lognormal")

varCompNBinom(size = 1, prob = 0.2, shape = log(1000) - 0.405, rate = 0.9^2,
          distr_severity = "Lognormale")

VatRCompNBinom(kap = 0.9, size = 1, prob = 0.2, shape = 0.59,
            rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")

vark_calc <- VatRCompNBinom(kap = 0.9, size = 1, prob = 0.2, shape = 0.59,
            rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")
TVatRCompNBinom(kap = 0.9, size = 1, prob = 0.2, shape = 0.59, rate = 0.9^2,
            vark = vark_calc, k0 = 1E2, distr_severity = "Gamma")

}
