% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom.R
\name{binom}
\alias{binom}
\alias{expValBinom}
\alias{varBinom}
\alias{expValTruncBinom}
\alias{VatRBinom}
\alias{TVatRBinom}
\alias{pgfBinom}
\alias{mgfBinom}
\title{Binomial Distribution}
\usage{
expValBinom(size, prob)

varBinom(size, prob)

expValTruncBinom(d, size, prob, less.than.d = TRUE)

VatRBinom(kap, size, prob)

TVatRBinom(kap, size, prob)

pgfBinom(t, size, prob)

mgfBinom(t, size, prob)
}
\arguments{
\item{size}{Number of trials (0 or more).}

\item{prob}{Probability of success in each trial.}

\item{d}{cut-off value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}

\item{t}{t.}
}
\value{
Function :
  \itemize{
    \item \code{\link{mgfBinom}}  gives the moment generating function (MGF).
    \item \code{\link{pgfBinom}}  gives the probability generating function (PGF).
    \item \code{\link{expValBinom}}  gives the expected value.
    \item \code{\link{varBinom}}  gives the variance.
    \item \code{\link{expValTruncBinom}}  gives the truncated mean.
    \item \code{\link{TVatRBinom}}  gives the Tail Value-at-Risk.
    \item \code{\link{VatRBinom}}  gives the Value-at-Risk.
  }
Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Binomial distribution with size \eqn{n}{n} and probability of
success \eqn{p}{p}.
}
\details{
The binomial distribution with probability of success \eqn{p}{p} for \eqn{n}{n} trials
has probability mass function :
  \deqn{Pr(X = k) = \left(\frac{n}{k}\right) p^n (1 - p)^{n - k}}{Pr(X = k) = n!/(k!(n - k)!) p^n(1 - p)^(n - k)}
for \eqn{k = 0, 1, 2, \dots, n}{k = 0, 1, 2, ..., n}, \eqn{p \in [0, 1]}{0 <= p <= 1}, and \eqn{n > 0}{n > 0}
}
\note{
Function VatRBinom is a wrapper of the \code{\link[stats]{qbinom}}
function from the stats package.
}
\examples{
expValBinom(size = 3, prob = 0.5)

varBinom(size = 3, prob = 0.5)


expValTruncBinom(d = 2, size = 3, prob = 0.5)
expValTruncBinom(d = 0, size = 3, prob = 0.5, less.than.d = FALSE)


VatRBinom(kap = 0.8, size = 5, prob = 0.2)

TVatRBinom(kap = 0.8, size = 5, prob = 0.2)


pgfBinom(t = 1, size = 3, prob = 0.5)

mgfBinom(t = 1, size = 3, prob = 0.5)

}
