% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics-CloudProvider.R,
%   R/method-default.R
\name{getDockerWorkerNumbers}
\alias{getDockerWorkerNumbers}
\alias{getDockerWorkerNumbers,ANY-method}
\title{Get the worker number on the cloud}
\usage{
getDockerWorkerNumbers(provider, cluster, verbose)

\S4method{getDockerWorkerNumbers}{ANY}(provider, cluster, verbose = 0L)
}
\arguments{
\item{provider}{S4 \code{CloudProvider} object. The service provider.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{verbose}{Integer. The verbose level, default 1.}
}
\value{
\verb{list(initializing = ?, running = ?)}.
}
\description{
Get the worker number on the cloud. Return a list with two elements,
which are the number of initializing and running workers. The names must
be \code{"initializing"} and \code{"running"}. The default method will
return \code{list(initializing = 0L, running = .getExpectedWorkerNumber(cluster))}
}
\section{Functions}{
\itemize{
\item \code{getDockerWorkerNumbers,ANY-method}: The default getDockerWorkerNumbers method. Return \code{c(0L, .getExpectedWorkerNumber(cluster))}
}}

