% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/InsuranceVaRES.R
\name{InsuranceVaRES}
\alias{InsuranceVaRES}
\title{VaR and ES of Insurance Portfolio}
\usage{
InsuranceVaRES(mu, sigma, n, p, theta, deductible, number.trials, cl)
}
\arguments{
\item{mu}{Mean of returns}

\item{sigma}{Volatility of returns}

\item{n}{Number of contracts}

\item{p}{Probability of any loss event}

\item{theta}{Expected profit per contract}

\item{deductible}{Deductible}

\item{number.trials}{Number of simulation trials}

\item{cl}{VaR confidence level}
}
\value{
A list with "VaR" and "ES" of the specified portfolio
}
\description{
Generates Monte Carlo VaR and ES for insurance portfolio.
}
\examples{
# Estimates VaR and ES of Insurance portfolio with given parameters
   y<-InsuranceVaRES(.8, 1.3, 100, .6, 21,  12, 50, .95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

