% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NormalVaRPlot2DHP.R
\name{NormalVaRPlot2DHP}
\alias{NormalVaRPlot2DHP}
\title{Plots normal VaR against holding period}
\usage{
NormalVaRPlot2DHP(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 3
 or 4. In case there 3 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.
returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 cl VaR confidence level and must be a scalar

 hp VaR holding period and must be a vector}
}
\description{
Plots the VaR of a portfolio against holding period assuming that P/L are
normally distributed, for specified confidence level and holding period.
}
\examples{
# Computes VaR given P/L data
   data <- runif(5, min = 0, max = .2)
   NormalVaRPlot2DHP(returns = data, cl = .95, hp = 60:90)

   # Computes VaR given mean and standard deviation of P/L data
   NormalVaRPlot2DHP(mu = .012, sigma = .03, cl = .99, hp = 40:80)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

