% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STOC.R
\name{STOC}
\alias{STOC}
\title{Scree Test Optimal Coordinate (STOC)}
\usage{
STOC(
  response,
  fa = "pc",
  nfact = 1,
  cor.type = "pearson",
  use = "pairwise.complete.obs",
  vis = TRUE,
  plot = TRUE
)
}
\arguments{
\item{response}{A required \code{N} × \code{I} matrix or data.frame consisting of the responses
of \code{N} individuals to \code{I} items.}

\item{fa}{A string that determines the method used to obtain eigenvalues in PA. If \code{"pc"}, it represents
Principal Component Analysis (PCA); if \code{"fa"}, it represents Principal Axis Factoring (a widely
used Factor Analysis method; @seealso \code{\link[EFAfactors]{factor.analysis}};
Auerswald & Moshagen, 2019). (Default = \code{"pc"})}

\item{nfact}{A numeric value that specifies the number of factors to extract, only effective when \code{fa = 'fa'}. (Default = 1)}

\item{cor.type}{A character string indicating which correlation coefficient (or covariance) is
to be computed. One of \code{"pearson"} (default), \code{"kendall"}, or
\code{"spearman"}. @seealso \code{\link[stats]{cor}}.}

\item{use}{an optional character string giving a method for computing covariances in the presence of missing values. This
must be one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"}, \code{"na.or.complete"},
or \code{"pairwise.complete.obs"} (default). @seealso \code{\link[stats]{cor}}.}

\item{vis}{A Boolean variable that will print the factor retention results when set to \code{TRUE}, and will not print
when set to \code{FALSE}. (default = \code{TRUE})}

\item{plot}{A Boolean variable that will print the STOC plot when set to \code{TRUE}, and will not print it when set to
\code{FALSE}. @seealso \code{\link[EFAfactors]{plot.STOC}}. (Default = \code{TRUE})}
}
\value{
An object of class \code{STOC}, which is a \code{list} containing the following components:
\item{nfact}{The number of factors to retain by both Optimal Coordinate and PA.}
\item{nfact.STOC}{The number of factors to retain only by Optimal Coordinate.}
\item{nfact.PA}{The number of factors to retain only by PA.}
\item{fa}{Indicates the method used to obtain eigenvalues. 'pc' represents Principal Component Analysis, and 'fa' represents Principal Axis Factoring.}
\item{eigen.value}{A vector containing the empirical eigenvalues.}
\item{eigen.ref}{A vector containing the reference eigenvalues by both Optimal Coordinate and PA.}
}
\description{
The STOC (Raiche et al., 2013) approach is based on fitting \eqn{I-2} (\eqn{I}
is the number of observed variables) two
point regression models using the (i+1)th and I-th (the last one) eigenvalue to
obtain a prediction for the i-th eigenvalue that is referred to as optimal
coordinate (with p being the number of observed variables and therefore
also the number of eigenvalues).  If the observed empirical eigenvalue is larger than the predicted
optimal coordinate. Raiche et al. (2013) also argue for a restricted version that retains
only factors with an eigenvalue greater than the reference eigenvalue by PA (holds PCA and
quant=0.95 in this package).
}
\examples{
library(EFAfactors)
set.seed(123)

##Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## loading data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1

\donttest{
 STOC.obj <- STOC(response, plot=FALSE)

 ## STOC plot
 plot(STOC.obj)

}

}
\references{
Raiche, G., Walls, T. A., Magis, D., Riopel, M., & Blais, J.-G. (2013). Non-graphical solutions for Cattell's scree test. Methodology, 9(1), 23-29. https://doi.org/10.1027/1614-2241/a000051

 Goretzko, D. (2025). How many factors to retain in exploratory factor analysis? A critical overview of factor retention methods. Psychological methods, Advance online publication. https://doi.org/10.1037/met0000733
}
\seealso{
\code{\link[EFAfactors]{STOC}}
}
