% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EFDR_functions.R
\name{fdrpower}
\alias{fdrpower}
\title{Power function}
\usage{
fdrpower(reject.true, reject)
}
\arguments{
\item{reject.true}{indices of the true alternative hypotheses}

\item{reject}{indices of the rejected null hypotheses}
}
\value{
Single value (proportion)
}
\description{
Returns the power of the multiple hypothesis test, by finding
the proportion of the correctly rejected null hypotheses.
}
\examples{
set.seed(1)
wf = "la8"
J = 3
n = 64
h = 0.5
Z <- test_image(h = h, r = 14, n1 = n)$z
sig <- wav_th(Z, wf=wf, J=J, th = h)

Z <- Z + rnorm(n^2)*0.5
m1 <- test.bonferroni(Z, wf="la8",J=3, alpha = 0.05)
m2 <- test.fdr(Z, wf="la8",J=3, alpha = 0.05)

cat(paste0("Bonferroni power: ",fdrpower(sig,m1$reject_coeff)))
cat(paste0("FDR power: ",fdrpower(sig,m2$reject_coeff)))
}
\references{
Shen, X., Huang, H.-C., and Cressie, N. 'Nonparametric hypothesis testing for a spatial signal.' Journal of the American Statistical Association 97.460 (2002): 1122-1140.
}
