% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wBTCode.R
\name{trendSetUp}
\alias{trendSetUp}
\title{Interactive setup for running wBT, the WRTDS Bootstrap Test}
\usage{
trendSetUp(eList, ...)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{\dots}{additional arguments to bring in to reduce interactive options 
(year1, year2, nBoot, bootBreak, blockLength)}
}
\value{
caseSetUp data frame with columns year1, yearData1, year2, yearData2, 
numSamples, nBoot, bootBreak, blockLength, confStop. These correspond to:
\tabular{ll}{
Column Name \tab Manuscript Variable\cr
year1 \tab \eqn{y_s} \cr
year2 \tab \eqn{y_e} \cr
nBoot \tab \eqn{M_max} \cr
bootBreak \tab \eqn{M_min} \cr
blockLength \tab \eqn{B} \cr
}
}
\description{
Walks user through the set-up for the WRTDS Bootstrap Test.  Establishes 
start and end year for the test period.  Sets the minimum number of 
bootstrap replicates to be run, the maximum number of bootstrap replicates 
to be run, and the block length (in days) for the block bootstrapping.
The test is designed to evaluate the uncertainty about the trend between any pair of years.
}
\examples{
eList <- EGRET::Choptank_eList

# Completely interactive:
# caseSetUp <- trendSetUp(eList)
# Semi-interactive:
# caseSetUp <- trendSetUp(eList, nBoot = 100, blockLength = 200)

# fully scripted:
caseSetUp <- trendSetUp(eList,
  year1=1985, 
  year2=2005,
  nBoot = 50, 
  bootBreak = 39,
  blockLength = 200)

}
\seealso{
\code{\link{setForBoot}}, \code{\link{wBT}}
}
\keyword{WRTDS}
\keyword{water-quality}
