% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wBTCode.R
\name{wBT}
\alias{wBT}
\title{Run the WBT (WRTDS Bootstrap Test)}
\usage{
wBT(eList, caseSetUp, saveOutput = TRUE, fileName = "temp.txt",
  startSeed = 494817, jitterOn = FALSE, V = 0.2)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{caseSetUp}{data frame. Returned from \code{\link{trendSetUp}}.}

\item{saveOutput}{logical. If \code{TRUE}, a text file will be saved in the working directory.}

\item{fileName}{character. Name to save the output file if \code{saveOutput=TRUE}.}

\item{startSeed}{setSeed value. Defaults to 494817. This is used to make repeatable output.}

\item{jitterOn}{logical, if TRUE, adds "jitter" to the data in an attempt to avoid some numerical problems.  Default = FALSE.  See Details below.}

\item{V}{numeric a multiplier for addition of jitter to the data, default = 0.2.  See Details below.}
}
\value{
eBoot, a named list with bootOut, wordsOut, xConc, xFlux, pConc, pFlux values.
\tabular{ll}{
Object \tab Description\cr
bootOut \tab a data frame with the results of the bootstrap test. \cr
wordsOut \tab a character vector describing the results. \cr
xConc and xFlux \tab vectors of length iBoot, of the change in flow normalized concentration
   and flow normalized flux computed from each of the bootstrap replicates. \cr
pConc and pFlux \tab vectors of length iBoot, of the change in flow normalized concentration
   or flow normalized flux computed from each of the bootstrap replicates expressed as \% change. \cr
}
}
\description{
Runs the WBT for a given data set to evaluate the significance level and 
confidence intervals for the trends between two specified years.  The trends 
evaluated are trends in flow normalized concentration and flow normalized flux.  
Function produces text outputs and a named list (eBoot) that contains all of the 
relevant outputs. Check out \code{\link{runPairsBoot}} and \code{\link{runGroupsBoot}}
for more bootstrapping options. 
The wBT only runs stationary flow normalization (i.e. making the assumption that discharge is stationary).  
The \code{\link{runPairsBoot}} and \code{\link{runGroupsBoot}} allow for generalized flow normalization (i.e. non-stationary discharge).
}
\details{
In some situations numerical problems are encountered in the bootstrap process, resulting in highly unreasonable spikes in the confidence intervals.
The use of "jitter" can often prevent these problems, but should only be used when it is clearly needed.
It adds a small amount of random "jitter" to the explanatory variables of the WRTDS model.  The V parameter sets the scale of variation in the log discharge values.
The standard deviation of the added jitter is V * standard deviation of Log Q.
The default for V is 0.2.  Larger values should generally be avoided, and smaller values may be sufficient.
}
\examples{
eList <- EGRET::Choptank_eList
caseSetUp <- trendSetUp(eList,
                        year1 = 1985, 
                        year2 = 2005,
                        nBoot = 50, 
                        bootBreak = 39,
                        blockLength = 200)
# Very long-running function:                     
\dontrun{
eBoot <- wBT(eList,caseSetUp)
}
}
\seealso{
\code{\link{trendSetUp}}, \code{\link{setForBoot}}, \code{\link{runGroupsBoot}}, \code{\link{runPairsBoot}}
}
