% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.resid.R
\name{raster.resid}
\alias{raster.resid}
\title{raster.resid Measure standardized residuals from a linear regression between two rasters.}
\usage{
raster.resid(x, y)
}
\arguments{
\item{x}{A raster or RasterLayer object, or ENMTools model object containing a suitability raster.}

\item{y}{Another raster  or RasterLayer object, or ENMTools model object containing a suitability raster.}
}
\value{
results A list containing a raster of residuals from a linear regression between the two supplied rasters and the linear model itself.
}
\description{
This function builds a linear model for the relationship between two rasters, and returns the linear model
and a spatial raster of the residuals from that model.
}
\examples{
data(euro.worldclim)
raster.resid(euro.worldclim[[1]], euro.worldclim[[2]])
}
\keyword{correlation}
\keyword{raster}
\keyword{residuals}
