% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETDQualitizer.R
\name{accuracy}
\alias{accuracy}
\title{Compute Gaze Accuracy}
\usage{
accuracy(azi, ele, target_azi, target_ele, central_tendency_fun = mean)
}
\arguments{
\item{azi}{Gaze azimuth in degrees.}

\item{ele}{Gaze elevation in degrees.}

\item{target_azi}{Target azimuth in degrees.}

\item{target_ele}{Target elevation in degrees.}

\item{central_tendency_fun}{Function to compute central tendency (default: \code{mean}).}
}
\value{
A list with \code{offset}, \code{offset_azi}, and \code{offset_ele}, the total, horizontal and vertical offset of gaze from the target (in degrees).
}
\description{
Calculates the angular offset between gaze and target directions.
}
\examples{
accuracy(c(1, 2), c(1, 2), 0, 0)
}
