% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_results}
\alias{plot_results}
\title{Plot the posterior means or probability distribution(s)}
\usage{
plot_results(
  jags_output,
  data,
  pred = NULL,
  prey = NULL,
  variable = c("eta", "PI"),
  save = FALSE,
  save_path = "."
)
}
\arguments{
\item{jags_output}{the mcmc.list object output by the run_model() function}

\item{data}{the preprocessed data list output by the preprocess_data() function}

\item{pred}{the predator name for which we want to plot the probability densities}

\item{prey}{the prey(s) name(s) for which we want to plot the probability densities}

\item{variable}{the variable(s) for which we want to plot the probability densities. By default
we will plot the two variables of interest: eta and PI.}

\item{save}{A boolean describing whether the figure should be saved as PNG. 
By default the figures are not saved.}

\item{save_path}{A string describing the path to which the figures should be saved.
By default the figures are saved in a temporary directory.}
}
\description{
This function plots the posterior means or probability distribution(s) for one 
or the two variable(s) of interest : the trophic link probabilities ("eta") and/or 
the diet proportions ("PI").

The figure(s) can be saved as PNG using: \code{save = TRUE}, and the directory path to which
the figures are saved can be precised with: \code{save_path = "."}.

If no "pred" nor "prey" parameter is entered, the plot will be a raster plot with the mean priors for 
all the trophic groups.

If one predator name is entered as "pred", the probability distribution(s) will be plotted for all its 
prey(s) by default. Some specific prey(s) name(s) can also be entered because if a predator has 
22 preys, plotting them all will make the plot hard to read. So you can specify the one or many prey(s) 
of interest and only display their corresponding probability distribution(s).

The "variable" parameter can be specified if one wants to plot the priors for only one variable 
("PI" or "eta").
}
\examples{

\donttest{
realistic_biotracer_data <- read.csv(system.file("extdata", "realistic_biotracer_data.csv",
                                               package = "EcoDiet"))
realistic_stomach_data <- read.csv(system.file("extdata", "realistic_stomach_data.csv",
                                             package = "EcoDiet"))

data <- preprocess_data(biotracer_data = realistic_biotracer_data,
                        trophic_discrimination_factor = c(0.8, 3.4),
                        literature_configuration = FALSE,
                        stomach_data = realistic_stomach_data)
                        
write_model(literature_configuration = FALSE)

mcmc_output <- run_model("EcoDiet_model.txt", data, run_param="test")
                        
plot_results(mcmc_output, data)
plot_results(mcmc_output, data, pred = "Crabs")
plot_results(mcmc_output, data, pred = "Crabs",
             variable = "PI", prey = c("Bivalves", "Shrimps"))
             
}

}
\seealso{
\code{\link{plot_prior}} to plot the prior means or probability distribution(s),
  \code{\link{plot_data}} to plot the input data
}
