% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hoover_curve.r
\name{hoover_curve}
\alias{hoover_curve}
\title{Plot a Hoover curve from regions - industries matrices}
\usage{
hoover_curve(mat, pop, plot = TRUE, pdf = FALSE, pdf_location = NULL)
}
\arguments{
\item{mat}{An incidence matrix with regions in rows and industries in columns. The input can also be a vector of industrial regional count (a matrix with n regions in rows and a single column).}

\item{pop}{A vector of population regional count}

\item{plot}{Logical; shall the curve be automatically plotted? Defaults to TRUE. If set to TRUE, the function will return x y coordinates that you can latter use to plot and customize the curve.}

\item{pdf}{Logical; shall a pdf be saved?  Defaults to FALSE. If set to TRUE, a pdf with all will be compiled and saved to R's temp dir if no 'pdf_location' is specified.}

\item{pdf_location}{Output location of pdf file}
}
\value{
If `plot = FALSE`, a list containing the cumulative distribution of population shares (`cum.reg`) and industry shares (`cum.out`) is returned. If `plot = TRUE`, no return value is specified.
}
\description{
This function plots a Hoover curve from regions - industries matrices.
}
\examples{
## generate vectors of industrial and population count
ind <- c(0, 10, 10, 30, 50)
pop <- c(10, 15, 20, 25, 30)

## run the function (30\% of the population produces 50\% of the industrial output)
hoover_curve (ind, pop)
hoover_curve (ind, pop, pdf = FALSE)
hoover_curve (ind, pop, plot = FALSE)

## generate a region - industry matrix
mat = matrix (
c (0, 10, 0, 0,
0, 15, 0, 0,
0, 20, 0, 0,
0, 25, 0, 1,
0, 30, 1, 1), ncol = 4, byrow = TRUE)
rownames(mat) <- c ("R1", "R2", "R3", "R4", "R5")
colnames(mat) <- c ("I1", "I2", "I3", "I4")

## run the function
hoover_curve (mat, pop)
hoover_curve (mat, pop, plot = FALSE)

## run the function by aggregating all industries
hoover_curve (rowSums(mat), pop)
hoover_curve (rowSums(mat), pop, plot = FALSE)

## run the function for industry #1 only
hoover_curve (mat[,1], pop)
hoover_curve (mat[,1], pop, plot = FALSE)

## run the function for industry #2 only (perfectly proportional to population)
hoover_curve (mat[,2], pop)
hoover_curve (mat[,2], pop, plot = FALSE)

## run the function for industry #3 only (30\% of the pop. produces 100\% of the output)
hoover_curve (mat[,3], pop)
hoover_curve (mat[,3], pop, plot = FALSE)

## run the function for industry #4 only (55\% of the pop. produces 100\% of the output)
hoover_curve (mat[,4], pop)
hoover_curve (mat[,4], pop, plot = FALSE)

## Compare the distribution of the #industries
oldpar <- par(mfrow = c(2, 2))  # Save the current graphical parameter settings
hoover_curve (mat[,1], pop)
hoover_curve (mat[,2], pop)
hoover_curve (mat[,3], pop)
hoover_curve (mat[,4], pop)
par(oldpar)  # Reset the graphical parameters to their original values

## Save output as pdf
hoover_curve (mat, pop, pdf = TRUE)

## To specify an output directory for the pdf,
## specify 'pdf_location', for instance as '/Users/jones/hoover_curve.pdf'
## hoover_curve(mat, pop, pdf = TRUE, pdf_location = '/Users/jones/hoover_curve.pdf')


}
\references{
Hoover, E.M. (1936) The Measurement of Industrial Localization, \emph{The Review of Economics and Statistics} \strong{18} (1): 162-171
}
\seealso{
\code{\link{hoover_gini}}, \code{\link{locational_gini}}, \code{\link{locational_gini_curve}}, \code{\link{lorenz_curve}}, \code{\link{gini}}
}
\author{
Pierre-Alexandre Balland \email{p.balland@uu.nl}
}
\keyword{concentration}
\keyword{inequality}
